<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.5.5
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);

namespace Mirasvit\Email\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;
use Mirasvit\Email\Api\Data\QueueInterface;

class QueueStatusSource implements OptionSourceInterface
{
    public function toOptionArray(): array
    {
        return [
            [
                'value' => QueueInterface::STATUS_PENDING,
                'label' => (string)__('Ready to go'),
            ],
            [
                'value' => QueueInterface::STATUS_SENT,
                'label' => (string)__('Sent'),
            ],
            [
                'value' => QueueInterface::STATUS_CANCELED,
                'label' => (string)__('Canceled'),
            ],
            [
                'value' => QueueInterface::STATUS_ERROR,
                'label' => (string)__('Error'),
            ],
            [
                'value' => QueueInterface::STATUS_MISSED,
                'label' => (string)__('Missed'),
            ],
            [
                'value' => QueueInterface::STATUS_UNSUBSCRIBED,
                'label' => (string)__('Unsubcribed'),
            ],
        ];
    }
}
