<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.5.5
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\Email\Api\Data;

use Mirasvit\Email\Model\ResourceModel\Trigger\Chain\Collection;

interface TriggerInterface
{
    const TABLE_NAME = 'mst_email_trigger';

    const ID                 = 'trigger_id';
    const CAMPAIGN_ID        = 'campaign_id';
    const TITLE              = 'title';
    const DESCRIPTION        = 'description';
    const STORE_IDS          = 'store_ids';
    const IS_ACTIVE          = 'is_active';
    const ACTIVE_FROM        = 'active_from';
    const ACTIVE_TO          = 'active_to';
    const TRIGGER_TYPE       = 'trigger_type';
    const EVENT              = 'event';
    const CANCELLATION_EVENT = 'cancellation_event';
    const RULE               = 'rule';
    const RULE_SERIALIZED    = 'rule_serialized';
    const SCHEDULE           = 'schedule';
    const SENDER_EMAIL       = 'sender_email';
    const SENDER_NAME        = 'sender_name';
    const COPY_EMAIL         = 'copy_email';
    const GA_SOURCE          = 'ga_source';
    const GA_MEDIUM          = 'ga_medium';
    const GA_TERM            = 'ga_term';
    const GA_CONTENT         = 'ga_content';
    const GA_NAME            = 'ga_name';
    const CREATED_AT         = 'created_at';
    const UPDATED_AT         = 'updated_at';

    const IS_ADMIN    = 'is_admin';
    const ADMIN_EMAIL = 'admin_email';

    const STATUS_ACTIVE   = 1;
    const STATUS_DISABLED = 0;

    const IS_ADMIN_ACTIVE   = 1;
    const IS_ADMIN_DISABLED = 0;

    public function getId();

    public function getTitle(): string;

    public function setTitle(string $title): self;

    public function getDescription(): string;

    public function setDescription(string $description): self;

    public function getRuleSerialized(): string;

    public function setRuleSerialized(string $value): self;

    public function getRule(): array;

    /**
     * @param string|array $rule
     *
     * @return $this
     */
    public function setRule($rule): self;

    public function getSchedule(): string;

    public function setSchedule(string $schedule): self;

    public function getTriggerType(): string;

    public function setTriggerType(string $triggerType): self;

    public function getEvents(): array;

    public function getEvent(): string;

    public function setEvent(string $event): self;

    public function getTriggeringEvents(): array;

    public function getCancellationEvents(): array;

    public function getCancellationEvent(): array;

    public function setCancellationEvent(array $cancellationEvent): self;

    public function getGaSource(): string;

    public function setGaSource(string $source): self;

    public function getGaMedium(): string;

    public function setGaMedium(string $medium): self;

    public function getGaName(): string;

    public function setGaName(string $name): self;

    public function getGaTerm(): string;

    public function setGaTerm(string $term): self;

    public function getGaContent(): string;

    public function setGaContent(string $content): self;

    public function getStoreIds(): array;

    public function setStoreIds(array $storeIds): self;

    public function setCampaignId(string $campaignId): self;

    public function getCampaignId(): string;

    public function getIsActive(): bool;

    public function setIsActive(bool $isActive): self;

    public function getSenderEmail(int $storeId = 0): string;

    public function setSenderEmail(string $senderEmail): self;

    public function getSenderName(int $storeId = 0): string;

    public function setSenderName(string $senderName): self;

    public function getActiveTo(): string;

    public function setActiveTo(string $activeTo): self;

    public function getActiveFrom(): string;

    public function setActiveFrom(string $activeFrom): self;

    public function getCreatedAt(): string;

    public function setCreatedAt(string $createdAt): self;

    public function getUpdatedAt(): string;

    public function setUpdatedAt(string $updatedAt): self;

    public function getIsAdmin(): int;

    public function setIsAdmin(int $value): self;

    public function getAdminEmail(): string;

    public function setAdminEmail(string $email): self;

    /**
     * @return Collection | ChainInterface[]
     */
    public function getChainCollection(): Collection;

    public function validateRules(array $args, bool $force = false): bool;

    /**
     * Object data getter
     *
     * If $key is not defined will return all the data as an array.
     * Otherwise it will return value of the element specified by $key.
     * It is possible to use keys like a/b/c for access nested array data
     *
     * If $index is specified it will assume that attribute data is an array
     * and retrieve corresponding member. If data is the string - it will be explode
     * by new line character and converted to array.
     *
     * @param string     $key
     * @param string|int $index
     * @return mixed
     */
    public function getData($key = '', $index = null);

    /**
     * If $key is empty, checks whether there's any data in the object
     * Otherwise checks if the specified attribute is set.
     *
     * @param string $key
     * @return bool
     */
    public function hasData($key = '');

    /**
     * Overwrite data in the object.
     *
     * The $key parameter can be string or array.
     * If $key is string, the attribute value will be overwritten by $value
     *
     * If $key is an array, it will overwrite all the data in the object.
     *
     * @param string|array  $key
     * @param mixed         $value
     *
     * @return $this
     */
    public function setData($key, $value = null);

    /**
     * Add data to the object.
     *
     * Retains previous data in the object.
     *
     * @param array $arr
     *
     * @return $this
     */
    public function addData(array $arr);

    /**
     * Save object data
     *
     * @return $this
     * @throws \Exception
     * @deprecated
     */
    public function save();

    /**
     * Load object data
     *
     * @param integer $modelId
     * @param null|string $field
     * @return $this
     * @deprecated
     */
    public function load($modelId, $field = null);

    /**
     * Delete object from database
     *
     * @return $this
     * @throws \Exception
     * @deprecated
     */
    public function delete();

    /**
     * Unset data from the object.
     *
     * @param null|string|array $key
     * @return $this
     */
    public function unsetData($key = null);
}
