<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.3.1
 * @copyright Copyright (C) 2022 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\Email\Controller\Adminhtml\Queue;

use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Registry;
use Magento\Framework\Stdlib\DateTime\TimezoneInterface;
use Mirasvit\Email\Service\FrontSessionInitiator;
use Mirasvit\Email\Controller\Adminhtml\Queue;
use Mirasvit\Email\Model\QueueFactory;
use Magento\Framework\App\ResourceConnection;

class Index extends Queue
{
    protected $timezone;

    protected $connection;

    protected $resource;
    private $FrontSessionInitiator;
    private $formKey;

    public function __construct(
        \Magento\Framework\Data\Form\FormKey $formKey,
        FrontSessionInitiator $FrontSessionInitiator,
        QueueFactory $queueRepository,
        TimezoneInterface $timezone,
        ResourceConnection $resourceConnection,
        Registry $registry,
        Context $context
    ) {
        $this->formKey = $formKey;
        $this->FrontSessionInitiator = $FrontSessionInitiator;
        $this->timezone = $timezone;
        $this->resource = $resourceConnection;
        $this->connection = $resourceConnection->getConnection();

        parent::__construct($queueRepository, $registry, $context);
    }

    /**
     * {@inheritdoc}
     */
    public function execute()
    {
        $this->FrontSessionInitiator->set($this->formKey->getFormKey()); // init session key to make possible to send emails

        /** @var \Magento\Backend\Model\View\Result\Page $resultPage */
        $resultPage = $this->resultFactory->create(ResultFactory::TYPE_PAGE);

        $mysqlTime = $this->connection->fetchOne('SELECT CURRENT_TIMESTAMP');

        $cronJob = $this->connection->select()->from(
            $this->resource->getTableName("cron_schedule"),
            [new \Zend_Db_Expr("MAX(executed_at)")]
        )
            ->limit(1);
        $lastCronRun = $this->connection->fetchOne($cronJob);


        $localTime = $this->timezone->formatDateTime(
            new \DateTime('', new \DateTimeZone($this->timezone->getConfigTimezone())),
            \IntlDateFormatter::MEDIUM,
            \IntlDateFormatter::SHORT,
            null
        );
        $mysqlTime = $this->timezone->formatDateTime(
            $mysqlTime,
            \IntlDateFormatter::MEDIUM,
            \IntlDateFormatter::SHORT,
            null,
            'UTC'
        );

        if (!$lastCronRun) {
            $cronTime = "<b>Cron job is not configured</b>";
        } else {
            $cronTime = $this->timezone->formatDateTime(
                new \DateTime($lastCronRun, new \DateTimeZone($this->timezone->getConfigTimezone())),
                \IntlDateFormatter::MEDIUM,
                \IntlDateFormatter::SHORT,
                null
            );
        }

        $this->context->getMessageManager()->addNotice((string)__(
            "Local time: %1
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                GMT/Mysql time: %2
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                Last cron job run time: %3",
            $localTime,
            $mysqlTime,
            $cronTime
        ));

        $this->initPage($resultPage);

        return $resultPage;
    }
}
