<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.3.1
 * @copyright Copyright (C) 2022 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\Email\Controller\Adminhtml\Event;

use Magento\Backend\App\Action;
use Magento\Framework\Controller\ResultFactory;
use Mirasvit\Event\Api\Repository\EventRepositoryInterface;
use Mirasvit\Email\Service\EventManagement;
use Mirasvit\Email\Repository\TriggerRepository;
use Mirasvit\Email\Model\Trigger\Handler;

class MassReset extends Action
{
    protected $triggerRepository;

    protected $handler;

    private $eventRepository;

    private $eventManagement;


    public function __construct(
        EventManagement   $eventManagement,
        EventRepositoryInterface   $eventRepository,
        TriggerRepository $triggerRepository,
        Handler                    $handler,
        Action\Context             $context
    ) {
        parent::__construct($context);
        $this->eventManagement   = $eventManagement;
        $this->eventRepository   = $eventRepository;
        $this->triggerRepository = $triggerRepository;
        $this->handler           = $handler;
    }

    /**
     * @inheritDoc
     */
    public function execute()
    {
        $eventIds = $this->getRequest()->getParam('event_id');

        if (!is_array($eventIds)) {
            $this->messageManager->addErrorMessage((string)__('Please select event(s)'));
        } else {
            try {
                foreach ($eventIds as $eventId) {
                    $event = $this->eventRepository->get($eventId);
                    if ($event->getId()) {
                        $this->eventManagement->removeProcessedTriggers($event->getId());
                        $triggers = $this->triggerRepository->getCollection()->addActiveFilter();
                        foreach ($triggers as $trigger) {
                            $this->handler->handleEvents($trigger, [$event]);
                        }
                    }
                }

                $this->messageManager->addSuccessMessage(
                   (string)__('Total of %1 record(s) were reset', count($eventIds))
                );
            } catch (\Exception $e) {
                $this->messageManager->addErrorMessage($e->getMessage());
            }
        }

        /** @var \Magento\Backend\Model\View\Result\Redirect $resultRedirect */
        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);

        return $resultRedirect->setPath('*/*/');
    }
}
