<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.3.1
 * @copyright Copyright (C) 2022 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\Email\Controller\Adminhtml\Chain;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Mirasvit\Email\Api\Data\CampaignInterface;
use Mirasvit\Email\Api\Data\ChainInterface;
use Mirasvit\Email\Repository\Trigger\ChainRepository;

class Save extends Action
{
    /**
     * Authorization level of a basic admin session for current page.
     */
    const ADMIN_RESOURCE = 'Mirasvit_Email::campaign';

    private $chainRepository;

    public function __construct(
        ChainRepository $chainRepository,
        Context         $context
    ) {
        $this->chainRepository = $chainRepository;

        parent::__construct($context);
    }

    /**
     * {@inheritdoc}
     */
    public function execute()
    {
        $resultRedirect = $this->resultRedirectFactory->create();

        if ($data = $this->getRequest()->getParams()) {
            $campaignId = (int)$this->getRequest()->getParam(CampaignInterface::ID);
            $chainId    = (int)$this->getRequest()->getParam(ChainInterface::ID);
            $model      = $this->chainRepository->get($chainId);

            try {
                $model->addData($data);
                $this->chainRepository->save($model);

                $this->messageManager->addSuccessMessage((string)__('Email was successfully saved'));

                return $resultRedirect->setPath('*/campaign/view', [CampaignInterface::ID => $campaignId]);
            } catch (\Exception $e) {
                $this->messageManager->addErrorMessage($e->getMessage());

                return $resultRedirect->setPath('*/campaign/view', [CampaignInterface::ID => $campaignId]);
            }
        }

        $this->messageManager->addErrorMessage((string)__('Unable to find email to save'));

        return $resultRedirect->setPath('*/campaign/');
    }
}
