<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.3.4
 * @copyright Copyright (C) 2022 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\EmailDesigner\Model;

use Magento\Framework\Model\AbstractModel;
use Magento\Framework\Model\Context;
use Magento\Framework\Registry;
use Mirasvit\EmailDesigner\Api\Data\ThemeInterface;
use Mirasvit\Core\Service\YamlService as YamlParser;

class Theme extends AbstractModel implements ThemeInterface
{
    protected $config;

    public function __construct(
        ConfigProvider $config,
        Context $context,
        Registry $registry
    ) {
        $this->config = $config;

        parent::__construct($context, $registry);
    }

    /**
     * {@inheritdoc}
     */
    protected function _construct()
    {
        $this->_init(\Mirasvit\EmailDesigner\Model\ResourceModel\Theme::class);
    }

    public function getId()
    {
        return $this->getData(self::ID) ? (int)$this->getData(self::ID) : null;
    }

    public function getTitle(): string
    {
        return (string)$this->getData(self::TITLE);
    }

    public function setTitle(string $title): ThemeInterface
    {
        $this->setData(self::TITLE, $title);

        return $this;
    }

    public function getDescription(): string
    {
        return (string)$this->getData(self::DESCRIPTION);
    }

    public function setDescription(string $description): ThemeInterface
    {
        $this->setData(self::DESCRIPTION, $description);

        return $this;
    }

    public function getTemplateText(): string
    {
        return (string)$this->getData(self::TEMPLATE_TEXT);
    }

    public function setTemplateText(string $text): ThemeInterface
    {
        $this->setData(self::TEMPLATE_TEXT, $text);

        return $this;
    }

    public function getAreas(): array
    {
        $areas = [];
        $matches = [];

        if (!preg_match_all(self::AREA_PATTERN_PHP, $this->getTemplateText(), $matches)) {
            preg_match_all(self::AREA_PATTERN_LIQUID, $this->getTemplateText(), $matches);
        }

        foreach ($matches[1] as $code) {
            $label = $code;
            $label = str_replace('_', ' ', $label);

            $areas[$code] = ucwords($label);
        }

        return $areas;
    }

    public function export(): string
    {
        $path = $this->config->getThemePath() . '/' . $this->getTitle() . '.json';

        file_put_contents($path, $this->toJson());

        return $path;
    }

    public function import(string $filePath): ThemeInterface
    {
        $parser = new YamlParser();

        $data = $parser->parse(file_get_contents($filePath));

        $model = $this->getCollection()
            ->addFieldToFilter('title', $data['title'])
            ->getFirstItem();

        $model->addData($data)
            ->save();

        return $model;
    }
}
