<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.3.4
 * @copyright Copyright (C) 2022 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\Email\Controller\Adminhtml\Event;

use Magento\Backend\App\Action\Context;
use Magento\Framework\Registry;
use Mirasvit\Email\Repository\TriggerRepository;
use Mirasvit\Email\Service\EventManagement;
use Mirasvit\Email\Controller\Adminhtml\Event;
use Mirasvit\Email\Model\Trigger\Handler;
use Mirasvit\Event\Api\Repository\EventRepositoryInterface;

class Reset extends Event
{
    protected $triggerRepository;

    protected $handler;

    private $eventManagement;

    public function __construct(
        EventManagement $eventManagement,
        TriggerRepository $triggerRepository,
        EventRepositoryInterface $eventRepository,
        Handler $handler,
        Registry $registry,
        Context $context
    ) {
        $this->eventManagement = $eventManagement;
        $this->triggerRepository = $triggerRepository;
        $this->handler = $handler;

        parent::__construct($eventRepository, $registry, $context);
    }

    /**
     * {@inheritdoc}
     */
    public function execute()
    {
        /** @var \Magento\Framework\Controller\Result\Redirect $resultRedirect */
        $resultRedirect = $this->resultRedirectFactory->create();

        $event = $this->initModel();

        if ($event->getId()) {
            $this->eventManagement->removeProcessedTriggers((int)$event->getId());

            $triggers = $this->triggerRepository->getCollection()->addActiveFilter();
            foreach ($triggers as $trigger) {
                $this->handler->handleEvents($trigger, [$event]);
            }

            $this->messageManager->addSuccessMessage((string)__('Done.'));
        }

        return $resultRedirect->setPath('*/*/');
    }
}
