<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.3.4
 * @copyright Copyright (C) 2022 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\Email\Api\Data;

use Mirasvit\EmailDesigner\Api\Data\TemplateInterface;

interface ChainInterface
{
    const TABLE_NAME = 'mst_email_trigger_chain';

    const ID                  = 'chain_id';
    const TRIGGER_ID          = 'trigger_id';
    const TEMPLATE_ID         = 'template_id';
    const DELAY               = 'delay';
    const DAY                 = 'day';
    const HOUR                = 'hour';
    const MINUTE              = 'minute';
    const SEND_FROM           = 'send_from';
    const SEND_TO             = 'send_to';
    const EXCLUDE_DAYS        = 'exclude_days';
    const CROSS_SELLS_ENABLED = 'cross_sells_enabled';
    const CROSS_SELLS_TYPE_ID = 'cross_sells_type_id';
    const CREATED_AT          = 'created_at';
    const UPDATED_AT          = 'updated_at';

    public function getId();

    public function setTemplateId(string $id): self;

    public function getTemplateId(): string;

    public function getTemplate(): TemplateInterface;

    public function getTriggerId(): int;

    public function setTriggerId(int $id): self;

    public function getDay(bool $inSeconds = false): int;

    public function getHour(bool $inSeconds = false): int;

    public function getMinute(bool $inSeconds = false): int;

    public function getSendFrom(): int;

    public function getSendTo(): int;

    public function getExcludeDays(): ?array;

    public function setDay(int $day): self;

    public function setHour(int $hour): self;

    public function setMinute(int $minute): self;

    public function setSendFrom(int $sendFrom): self;

    public function setSendTo(int $sendTo): self;

    public function setExcludeDays(array $excludeDays = null): self;

    /**
     * Whether the cross sell products appearance enabled or not.
     */
    public function getCrossSellsEnabled(): bool;

    /**
     * Get type of used cross sell source.
     */
    public function getCrossSellsTypeId(): string;

    /**
     * Get method name used to retrieve products.
     */
    public function getCrossSellMethodName(): ?string;

    /**
     * Calculate Scheduled At.
     */
    public function getScheduledAt(int $time): int;

    /**
     * If $key is empty, checks whether there's any data in the object
     * Otherwise checks if the specified attribute is set.
     *
     * @param string $key
     * @return bool
     */
    public function hasData($key = '');

    /**
     * Object data getter
     *
     * If $key is not defined will return all the data as an array.
     * Otherwise it will return value of the element specified by $key.
     * It is possible to use keys like a/b/c for access nested array data
     *
     * If $index is specified it will assume that attribute data is an array
     * and retrieve corresponding member. If data is the string - it will be explode
     * by new line character and converted to array.
     *
     * @param string $key
     * @param string|int $index
     * @return mixed
     */

    public function getData($key = '', $index = null);

    /**
     * Add data to the object.
     *
     * Retains previous data in the object.
     *
     * @param array $arr
     * @return $this
     */
    public function addData(array $arr);

    /**
     * Save object data
     *
     * @return $this
     * @throws \Exception
     * @deprecated
     */
    public function save();

    /**
     * Load object data
     *
     * @param integer $modelId
     * @param null|string $field
     * @return $this
     * @deprecated
     */
    public function load($modelId, $field = null);

    /**
     * Delete object from database
     *
     * @return $this
     * @throws \Exception
     * @deprecated
     */
    public function delete();

    /**
     * Convert object data into string with predefined format
     *
     * Will use $format as an template and substitute {{key}} for attributes
     *
     * @param string $format
     * @return string
     */
    public function toString($format = '');

    /**
     * Unset data from the object.
     *
     * @param null|string|array $key
     * @return $this
     */
    public function unsetData($key = null);
}
