<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.3.5
 * @copyright Copyright (C) 2022 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\EmailReport\Repository;

use Magento\Framework\EntityManager\EntityManager;
use Mirasvit\EmailReport\Api\Data\OrderInterface;
use Mirasvit\EmailReport\Api\Data\OrderInterfaceFactory;
use Mirasvit\EmailReport\Model\ResourceModel\Order\Collection;
use Mirasvit\EmailReport\Model\ResourceModel\Order\CollectionFactory;
use Magento\Framework\Stdlib\DateTime;

class OrderRepository
{
    private $entityManager;

    private $factory;

    private $collectionFactory;

    public function __construct(
        OrderInterfaceFactory $factory,
        CollectionFactory $collectionFactory,
        EntityManager $entityManager
    ) {
        $this->factory           = $factory;
        $this->collectionFactory = $collectionFactory;
        $this->entityManager     = $entityManager;
    }

    public function getCollection(): Collection
    {
        return $this->collectionFactory->create();
    }

    public function get(int $id): ?OrderInterface
    {
        /** @var OrderInterface $order */
        $order = $this->factory->create();
        $order = $this->entityManager->load($order, $id);

        return $order->getId() ? $order : null;
    }

    public function create(): OrderInterface
    {
        return $this->factory->create();
    }

    public function save(OrderInterface $order): OrderInterface
    {
        $order->setCreatedAt((new \DateTime())->format(DateTime::DATETIME_PHP_FORMAT));

        return $this->entityManager->save($order);
    }

    public function ensure(OrderInterface $order): OrderInterface
    {
        $size = $this->getCollection()
            ->addFieldToFilter(OrderInterface::QUEUE_ID, $order->getQueueId())
            ->addFieldToFilter(OrderInterface::PARENT_ID, $order->getParentId())
            ->getSize();

        if (!$size) {
            $this->save($order);
        }

        return $order;
    }

    public function delete(OrderInterface $order): bool
    {
        return $this->entityManager->delete($order);
    }
}
