<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.3.5
 * @copyright Copyright (C) 2022 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);

namespace Mirasvit\EmailDesigner\Service\TemplateEngine\Liquid\Variable;

use Magento\Review\Model\ReviewFactory;
use Magento\Catalog\Model\ProductFactory;
use Mirasvit\Email\Model\ConfigProvider;
use Mirasvit\EmailDesigner\Service\TemplateEngine\Liquid\Variable\AbstractVariable;

class Review extends AbstractVariable
{
    protected $supportedTypes = [\Magento\Review\Model\Review::class];

    private $config;

    private $reviewFactory;

    private $productFactory;

    public function __construct(
        ReviewFactory $reviewFactory,
        ProductFactory $productFactory,
        ConfigProvider $config
    ) {
        $this->reviewFactory = $reviewFactory;
        $this->productFactory = $productFactory;
        $this->config = $config;
    }

    /**
     * @return \Magento\Review\Model\Review
     */
    public function getReview()
    {
        $review = $this->reviewFactory->create();

        if ($this->context->getData('review')) {
            return $this->context->getData('review');
        } elseif ($this->context->getData('review_id')) {
            $review = $this->reviewFactory->create()
                ->load($this->context->getData('review_id'));
        }

        $this->context->setData('review', $review);

        return $review;
    }

    /**
     * Get review details
     *
     * @return string
     */
    public function getDetail()
    {
        return $this->getReview()->getData('detail');
    }

    /**
     * Get review title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->getReview()->getData('title');
    }

    /**
     * Get customer nickname
     *
     * @return string
     */
    public function getNickname()
    {
        return $this->getReview()->getData('nickname');
    }
}
