<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.3.5
 * @copyright Copyright (C) 2022 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\Email\Model;

use Magento\Framework\Model\AbstractModel;
use Magento\Framework\Model\Context;
use Magento\Framework\Registry;
use Magento\Newsletter\Model\SubscriberFactory;
use Mirasvit\Email\Api\Data\TriggerInterface;
use Mirasvit\Email\Api\Data\UnsubscriptionInterface;

class Unsubscription extends AbstractModel implements UnsubscriptionInterface
{
    protected $subscriberFactory;

    public function __construct(
        SubscriberFactory $subscriberFactory,
        Context $context,
        Registry $registry
    ) {
        $this->subscriberFactory = $subscriberFactory;

        parent::__construct($context, $registry);
    }

    /**
     * {@inheritdoc}
     */
    protected function _construct()
    {
        $this->_init(\Mirasvit\Email\Model\ResourceModel\Unsubscription::class);
    }

    public function unsubscribe(string $email, int $triggerId = null): bool
    {
        $triggerId = intval($triggerId);

        $item = $this->getCollection()
            ->addFieldToFilter(self::EMAIL, $email)
            ->addFieldToFilter(TriggerInterface::ID, [0, $triggerId])
            ->getFirstItem();

        if (!$item->getId() || $triggerId == 0) {
            $item->setTriggerId($triggerId);
        }

        $item->setEmail($email);

        $item->save();

        return true;
    }

    public function unsubscribeNewsletter(string $email): bool
    {
        $subscriber = $this->subscriberFactory->create()->loadByEmail($email);

        if ($subscriber->getId()) {
            $subscriber->unsubscribe();
        }

        return true;
    }

    public function isUnsubscribed(string $email, int $triggerId): bool
    {
        $item = $this->getCollection()
            ->addFieldToFilter(self::EMAIL, $email)
            ->addFieldToFilter(TriggerInterface::ID, [0, $triggerId])
            ->getFirstItem();

        return $item->getId() ? true : false;
    }
}
