<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.5.0
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\EmailReport\Repository;

use Magento\Framework\EntityManager\EntityManager;
use Mirasvit\EmailReport\Api\Data\ReviewInterface;
use Mirasvit\EmailReport\Api\Data\ReviewInterfaceFactory;
use Mirasvit\EmailReport\Model\ResourceModel\Review\Collection;
use Mirasvit\EmailReport\Model\ResourceModel\Review\CollectionFactory;
use Magento\Framework\Stdlib\DateTime;

class ReviewRepository
{
    private $entityManager;

    private $collectionFactory;

    private $factory;

    public function __construct(
        ReviewInterfaceFactory $factory,
        CollectionFactory $collectionFactory,
        EntityManager $entityManager
    ) {
        $this->factory           = $factory;
        $this->collectionFactory = $collectionFactory;
        $this->entityManager     = $entityManager;
    }

    public function getCollection(): Collection
    {
        return $this->collectionFactory->create();
    }

    public function get(int $id): ?ReviewInterface
    {
        $review = $this->factory->create();
        $review = $this->entityManager->load($review, $id);

        return $review->getId() ? $review : null;
    }

    public function create(): ReviewInterface
    {
        return $this->factory->create();
    }

    public function save(ReviewInterface $review): ReviewInterface
    {
        $review->setCreatedAt((new \DateTime())->format(DateTime::DATETIME_PHP_FORMAT));

        return $this->entityManager->save($review);
    }

    public function ensure(ReviewInterface $review): ReviewInterface
    {
        $size = $this->getCollection()
            ->addFieldToFilter(ReviewInterface::QUEUE_ID, $review->getQueueId())
            ->addFieldToFilter(ReviewInterface::PARENT_ID, $review->getParentId())
            ->getSize();

        if (!$size) {
            $this->save($review);
        }

        return $review;
    }

    public function delete(ReviewInterface $review): bool
    {
        return $this->entityManager->delete($review);
    }
}
