<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.5.0
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);

namespace Mirasvit\Email\Setup\Patch\Data;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\Patch\PatchVersionInterface;
use Mirasvit\Email\Repository\Trigger\ChainRepository;
use Mirasvit\Email\Model\ResourceModel\Trigger\Chain\Collection as ChainCollection;
use Mirasvit\Email\Model\Trigger\Chain;
use Mirasvit\Email\Repository\TriggerRepository;
use Mirasvit\EmailDesigner\Model\ThemeFactory;
use Mirasvit\EmailDesigner\Model\TemplateFactory;
use Mirasvit\Core\Service\YamlService as YamlParser;


class DataPatch100 implements DataPatchInterface, PatchVersionInterface
{
    private $setup;
    private $themeFactory;
    private $templateFactory;
    private $yamlParser;
    private $triggerRepository;

    public function __construct(
        ModuleDataSetupInterface $setup,
        TriggerRepository $triggerRepository,
        YamlParser $yamlParser,
        ThemeFactory $themeFactory,
        TemplateFactory $templateFactory
    ) {
        $this->setup = $setup;
        $this->themeFactory = $themeFactory;
        $this->templateFactory = $templateFactory;
        $this->yamlParser = $yamlParser;
        $this->triggerRepository = $triggerRepository;
    }

    /**
     * @inheritdoc
     */
    public function apply()
    {
        $this->setup->getConnection()->startSetup();

        $setupPath = dirname(__FILE__, 3);
        $themePath = $setupPath . '/data/theme/';
        foreach (scandir($themePath) as $file) {
            if (substr($file, 0, 1) == '.') {
                continue;
            }
            $this->themeFactory->create()->import($themePath . $file);
        }

        $templatePath = $setupPath. '/data/template/';
        foreach (scandir($templatePath) as $file) {
            if (substr($file, 0, 1) == '.') {
                continue;
            }
            $this->templateFactory->create()->import($templatePath . $file);
        }
        $this->setup->getConnection()->endSetup();
    }

    /**
     * {@inheritdoc}
     */
    public static function getVersion(): string
    {
        return '1.0.0';
    }


    /**
     * {@inheritdoc}
     */
    public static function getDependencies() {
        return [];
    }

    /**
     * {@inheritdoc}
     */
    public function getAliases() {
        return [];
    }
}
