<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.5.0
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\Email\Controller\Adminhtml\Queue;

use Magento\Backend\App\Action\Context;
use Magento\Framework\Registry;
use Magento\Ui\Component\MassAction\Filter;
use Mirasvit\Email\Controller\Adminhtml\Queue;
use Mirasvit\Email\Repository\QueueRepository;

class MassDelete extends Queue
{
    private $filter;

    public function __construct(
        Filter          $filter,
        QueueRepository $queueRepository,
        Registry        $registry,
        Context         $context
    ) {
        $this->filter = $filter;

        parent::__construct($queueRepository, $registry, $context);
    }

    /**
     * {@inheritdoc}
     */
    public function execute()
    {
        $resultRedirect = $this->resultRedirectFactory->create();

        $ids = $this->filter->getCollection($this->queueRepository->getCollection())->getAllIds();

        $removed = 0;
        foreach ($ids as $id) {
            $this->queueRepository->delete($this->queueRepository->get((int)$id));

            $removed++;
        }

        $this->messageManager->addSuccessMessage(
            (string)__('A total of %1 record(s) have been removed.', $removed)
        );

        return $resultRedirect->setPath('*/*/');
    }
}
