<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.5.0
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\Email\Controller\Adminhtml\Chain;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Model\AbstractModel;
use Mirasvit\Email\Api\Data\CampaignInterface;
use Mirasvit\Email\Api\Data\ChainInterface;
use Mirasvit\Email\Repository\Repository;
use Mirasvit\Email\Repository\Trigger\ChainRepository;
use Mirasvit\Email\Service\CloneService;

class Duplicate extends Action
{
    /**
     * Authorization level of a basic admin session for current page.
     */
    const ADMIN_RESOURCE = 'Mirasvit_Email::campaign';

    private $clonner;

    private $chainRepository;


    public function __construct(
        CloneService $clonner,
        ChainRepository $chainRepository,
        Context $context
    ) {
        $this->clonner = $clonner;

        parent::__construct($context);
        $this->chainRepository = $chainRepository;
    }

    /**
     * {@inheritdoc}
     */
    public function execute()
    {
        $resultRedirect = $this->resultRedirectFactory->create();

        if ($data = $this->getRequest()->getParams()) {
            $campaignId = $this->getRequest()->getParam(CampaignInterface::ID);
            $model = $this->chainRepository->get((int)$this->getRequest()->getParam(ChainInterface::ID));

            try {
                $this->duplicate($model);

                $this->messageManager->addSuccessMessage((string)__('Email was successfully duplicated.'));

                return $resultRedirect->setPath('*/campaign/view', [CampaignInterface::ID => $campaignId]);
            } catch (\Exception $e) {
                $this->messageManager->addErrorMessage($e->getMessage());
                return $resultRedirect->setPath('*/campaign/view', [CampaignInterface::ID => $campaignId]);
            }
        }

        $this->messageManager->addErrorMessage((string)__('Unable to find email to duplicate'));

        return $resultRedirect->setPath('*/campaign/index');
    }

    private function duplicate(ChainInterface $chain): ChainInterface
    {
        $chainClone = $this->clonner->duplicate($chain, $this->chainRepository, [
            ChainInterface::ID,
            ChainInterface::CREATED_AT,
            ChainInterface::UPDATED_AT
        ]);

        return $chainClone;
    }
}
