<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.5.0
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);

namespace Mirasvit\Email\Block\Adminhtml\Customer\Edit\Tab\Email;

use Magento\Backend\Block\Widget\Grid\Extended as ExtendedGrid;
use Magento\Backend\Block\Template\Context;
use Magento\Backend\Helper\Data as BackendHelper;
use Mirasvit\Email\Api\Data\QueueInterface;
use Mirasvit\Email\Model\ResourceModel\Queue\CollectionFactory as QueueCollectionFactory;
use Mirasvit\Email\Model\ResourceModel\Trigger\CollectionFactory as TriggerCollectionFactory;
use Magento\Framework\Registry;
use Magento\Customer\Api\CustomerRepositoryInterface;
use Magento\Customer\Controller\RegistryConstants;
use Mirasvit\Email\Model\Queue;

class Grid extends ExtendedGrid
{
    protected $registry;

    protected $queueCollectionFactory;

    protected $triggerCollectionFactory;

    protected $customerRepository;

    public function __construct(
        QueueCollectionFactory $queueCollectionFactory,
        TriggerCollectionFactory $triggerCollectionFactory,
        CustomerRepositoryInterface $customerRepository,
        Context $context,
        BackendHelper $backendHelper,
        Registry $registry
    ) {
        $this->queueCollectionFactory = $queueCollectionFactory;
        $this->triggerCollectionFactory = $triggerCollectionFactory;
        $this->customerRepository = $customerRepository;
        $this->registry = $registry;

        parent::__construct($context, $backendHelper);
    }

    /**
     * @return void
     */
    protected function _construct()
    {
        parent::_construct();
        $this->setId('queueGrid');
        $this->setDefaultSort('queue_id');
        $this->setDefaultDir('desc');

        $this->setEmptyText((string)__('No Emails Found'));
    }

    /**
     * @return $this
     */
    protected function _prepareCollection()
    {
        $customer = $this->customerRepository->getById(
            $this->registry->registry(RegistryConstants::CURRENT_CUSTOMER_ID)
        );
        /** @var \Mirasvit\Email\Model\ResourceModel\Queue\Collection $collection */
        $collection = $this->queueCollectionFactory->create()
            ->addFieldToFilter('recipient_email', $customer->getEmail());

        $this->setCollection($collection);

        return parent::_prepareCollection();
    }

    /**
     * @return $this
     */
    protected function _prepareColumns()
    {
        $this->addColumn('queue_id', [
            'header'   => (string)__('ID'),
            'type'     => 'number',
            'index'    => 'queue_id',
            'filter'   => false,
            'sortable' => false,
        ]);

        $this->addColumn('status', [
            'header'   => (string)__('Status'),
            'index'    => 'status',
            'type'     => 'options',
            'options'  => [
                QueueInterface::STATUS_PENDING      => (string)__('Ready to go'),
                QueueInterface::STATUS_SENT         => (string)__('Sent'),
                QueueInterface::STATUS_CANCELED     => (string)__('Canceled'),
                QueueInterface::STATUS_ERROR        => (string)__('Error'),
                QueueInterface::STATUS_MISSED       => (string)__('Missed'),
                QueueInterface::STATUS_UNSUBSCRIBED => (string)__('Unsubcribed'),
            ],
            'filter'   => false,
            'sortable' => false,
        ]);

        $this->addColumn('trigger_id', [
            'header'   => (string)__('Trigger'),
            'index'    => 'trigger_id',
            'type'     => 'options',
            'options'  => $this->triggerCollectionFactory->create()->toOptionHash(),
            'filter'   => false,
            'sortable' => false,
        ]);

        $this->addColumn('scheduled_at', [
            'header'   => (string)__('Scheduled At'),
            'type'     => 'datetime',
            'index'    => 'scheduled_at',
            'filter'   => false,
            'sortable' => false,
        ]);

        $this->addColumn('sent_at', [
            'header'   => (string)__('Sent At'),
            'type'     => 'datetime',
            'index'    => 'sent_at',
            'filter'   => false,
            'sortable' => false,
        ]);

        return parent::_prepareColumns();
    }
}
