<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.4.8
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\EmailReport\Repository;

use Magento\Framework\EntityManager\EntityManager;
use Mirasvit\EmailReport\Api\Data\ClickInterface;
use Mirasvit\EmailReport\Api\Data\ClickInterfaceFactory;
use Mirasvit\EmailReport\Model\ResourceModel\Click\Collection;
use Mirasvit\EmailReport\Model\ResourceModel\Click\CollectionFactory;
use Magento\Framework\Stdlib\DateTime;

class ClickRepository
{
    private $entityManager;

    private $factory;

    private $collectionFactory;

    public function __construct(
        ClickInterfaceFactory $factory,
        CollectionFactory $collectionFactory,
        EntityManager $entityManager
    ) {
        $this->factory = $factory;
        $this->collectionFactory = $collectionFactory;
        $this->entityManager = $entityManager;
    }

    public function getCollection(): Collection
    {
        return $this->collectionFactory->create();
    }

    public function get(int $id): ?ClickInterface
    {
        $click = $this->factory->create();
        $click = $this->entityManager->load($click, $id);

        return $click->getId() ? $click : null;
    }

    public function create(): ClickInterface
    {
        return $this->factory->create();
    }

    public function save(ClickInterface $click): ClickInterface
    {

        $click->setCreatedAt((new \DateTime())->format(DateTime::DATETIME_PHP_FORMAT));

        return $this->entityManager->save($click);
    }

    public function ensure(ClickInterface $click): ClickInterface
    {
        $size = $this->getCollection()
            ->addFieldToFilter(ClickInterface::QUEUE_ID, $click->getQueueId())
            ->getSize();

        if (!$size) {
            $this->save($click);
        }

        return $click;
    }

    public function delete(ClickInterface $click): bool
    {
        return $this->entityManager->delete($click);
    }
}
