<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.4.8
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\EmailReport\Plugin;

use Magento\Review\Model\Review;
use Mirasvit\EmailReport\Repository\ReviewRepository;
use Mirasvit\EmailReport\Service\StorageService;

class ReviewPlugin
{
    private $storageService;

    private $reviewRepository;


    public function __construct(
        StorageService $storageService,
        ReviewRepository $reviewRepository
    ) {
        $this->storageService = $storageService;
        $this->reviewRepository = $reviewRepository;
    }

    /**
     * @param Review $review
     * @return Review
     */
    public function afterSave($review)
    {
        if ($queue = $this->storageService->retrieveQueue()) {
            $review = $this->reviewRepository->create()
                ->setTriggerId($queue->getTriggerId())
                ->setQueueId($queue->getId())
                ->setParentId($review->getId());

            $this->reviewRepository->ensure($review);
        }

        return $review;
    }
}
