<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.4.8
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\EmailDesigner\Model\Email;

use Mirasvit\EmailDesigner\Api\Data\TemplateInterface;
use Magento\Email\Model\Template as EmailTemplate;
use Mirasvit\EmailDesigner\Api\Data\ThemeInterface;
use Mirasvit\EmailDesigner\Model\Email\Context as TemplateContext;
use Magento\Framework\Model\Context;
use Magento\Framework\View\DesignInterface;
use Magento\Framework\Registry;
use Magento\Store\Model\App\Emulation;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Framework\View\Asset\Repository;
use Magento\Framework\Filesystem;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Email\Model\Template\Config;
use Magento\Email\Model\TemplateFactory;
use Magento\Framework\Filter\FilterManager;
use Magento\Framework\UrlInterface;
use Magento\Email\Model\Template\FilterFactory;

/**
 * @SuppressWarnings(PHPMD.CouplingBetweenObjects)
 */
class Template extends EmailTemplate implements TemplateInterface
{
    const TYPE          = 'email';
    const ADDED_AT      = 'added_at';
    const MODIFIED_AT   = 'modified_at';
    const TEMPLATE_CODE = 'template_code';

    private $templateContext;

    /**
     * @SuppressWarnings(PHPMD.ExcessiveParameterList)
     */
    public function __construct(
        TemplateContext $templateContext,
        Context $context,
        DesignInterface $design,
        Registry $registry,
        Emulation $appEmulation,
        StoreManagerInterface $storeManager,
        Repository $assetRepo,
        Filesystem $filesystem,
        ScopeConfigInterface $scopeConfig,
        Config $emailConfig,
        TemplateFactory $templateFactory,
        FilterManager $filterManager,
        UrlInterface $urlModel,
        FilterFactory $filterFactory,
        array $data = []
    ) {
        $this->templateContext = $templateContext;

        parent::__construct(
            $context,
            $design,
            $registry,
            $appEmulation,
            $storeManager,
            $assetRepo,
            $filesystem,
            $scopeConfig,
            $emailConfig,
            $templateFactory,
            $filterManager,
            $urlModel,
            $filterFactory,
            $data
        );
    }

    public function getTitle(): string
    {
        return (string)$this->getData(self::TEMPLATE_CODE);
    }

    public function setTitle(string $title): TemplateInterface
    {
        return $this;
    }

    public function getDescription(): string
    {
        return '';
    }

    public function setDescription(string $description): TemplateInterface
    {
        return $this;
    }

    public function getTemplateSubject(): string
    {
        return (string)$this->getData(self::TEMPLATE_SUBJECT);
    }

    public function getTemplateText(): string
    {
        return (string)$this->getData(ThemeInterface::TEMPLATE_TEXT);
    }

    public function setTemplateSubject(string $subject): TemplateInterface
    {
        return $this;
    }

    public function getAreas(): array
    {
        return [];
    }

    public function getTemplateAreas(): array
    {
        return [];
    }

    public function setTemplateAreas(array $areas): TemplateInterface
    {
        return $this;
    }

    public function getTemplateAreasSerialized(): string
    {
        return '';
    }

    public function setTemplateAreasSerialized(string $dataSerialized): TemplateInterface
    {
        return $this;
    }

    public function getThemeId(): int
    {
        return null;
    }

    public function setThemeId(int $themeId): TemplateInterface
    {
        return $this;
    }

    public function setTheme(ThemeInterface $theme): TemplateInterface
    {
        return $this;
    }

    public function getTheme(): ?ThemeInterface
    {
        return null;
    }

    public function getAreaText(string $code): ?string
    {
        return null;
    }

    public function setAreaText(string $code, string $content): TemplateInterface
    {
        return $this;
    }

    public function getAreaCodeByContent(string $content): ?string
    {
        return null;
    }

    public function getUpdatedAt(): string
    {
        return (string)$this->getData(self::MODIFIED_AT);
    }

    public function setUpdatedAt(string $updatedAt): TemplateInterface
    {
        return $this;
    }

    public function getCreatedAt(): string
    {
        return (string)$this->getData(self::ADDED_AT);
    }

    public function setCreatedAt(string $createdAt): TemplateInterface
    {
        return $this;
    }

    public function isSystem(): bool
    {
        return false;
    }

    public function setSystemId(int $id): TemplateInterface
    {
        return $this;
    }

    public function export(): string
    {
        return '';
    }

    public function import(string $filePath): TemplateInterface
    {
        return $this;
    }

    /**
     * @param array $variables
     * @param bool|int|\Magento\Store\Model\Store|string|null $storeId
     * @return array|mixed
     */
    protected function addEmailVariables($variables, $storeId)
    {
        $variables = parent::addEmailVariables($variables, $storeId);
        $variables = $this->templateContext->addEmailVariables($variables, (int)$storeId);

        return $variables;
    }
}
