<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.4.8
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);

namespace Mirasvit\Email\Ui\Event\Listing\Column;

use Magento\Framework\UrlInterface;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\Listing\Columns\Column;
use Mirasvit\Event\Api\Data\EventInterface;

class Actions extends Column
{
    private $urlBuilder;

    public function __construct(
        UrlInterface       $urlBuilder,
        ContextInterface   $context,
        UiComponentFactory $uiComponentFactory,
        array              $components = [],
        array              $data = []
    ) {
        $this->urlBuilder = $urlBuilder;

        parent::__construct($context, $uiComponentFactory, $components, $data);
    }

    public function prepareDataSource(array $dataSource): array
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as &$item) {
                $item[$this->getData('name')] = [
                    'reset' => [
                        'href'  => $this->urlBuilder->getUrl('email/event/reset', [
                            EventInterface::ID => $item[EventInterface::ID],
                        ]),
                        'label' => __('Reset & Process'),
                    ],
                    'validate' => [
                        'href'  => $this->urlBuilder->getUrl('email/event/validate', [
                            EventInterface::ID => $item[EventInterface::ID],
                        ]),
                        'label' => __('Validate'),
                    ],
                    'delete' => [
                        'href'  => $this->urlBuilder->getUrl('email/event/delete', [
                            EventInterface::ID => $item[EventInterface::ID],
                        ]),
                        'label' => __('Delete'),
                    ],
                ];
            }
        }

        return $dataSource;
    }
}
