<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.4.8
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\Email\Repository;

use Magento\Framework\EntityManager\EntityManager;
use Mirasvit\Email\Api\Data\CampaignInterface;
use Mirasvit\Email\Api\Data\CampaignInterfaceFactory;
use Mirasvit\Email\Model\ResourceModel\Campaign\Collection;
use Mirasvit\Email\Model\ResourceModel\Campaign\CollectionFactory;

class CampaignRepository
{
    /**
     * @var CampaignInterface[]
     */
    private $campaignRegistry = [];

    private $entityManager;

    private $modelFactory;

    private $collectionFactory;


    public function __construct(
        EntityManager $entityManager,
        CampaignInterfaceFactory $modelFactory,
        CollectionFactory $collectionFactory
    ) {
        $this->entityManager = $entityManager;
        $this->modelFactory = $modelFactory;
        $this->collectionFactory = $collectionFactory;
    }

    public function getCollection(): Collection
    {
        return $this->collectionFactory->create();
    }

    public function create(): CampaignInterface
    {
        return $this->modelFactory->create();
    }

    public function get(int $id): ?CampaignInterface
    {
        if (isset($this->campaignRegistry[$id])) {
            return $this->campaignRegistry[$id];
        }

        $campaign = $this->create();
        $campaign = $this->entityManager->load($campaign, $id);

        if ($campaign->getId()) {
            $this->campaignRegistry[$id] = $campaign;
        } else {
            return null;
        }

        return $campaign;
    }

    public function save(CampaignInterface $model): CampaignInterface
    {
        $this->entityManager->save($model);

        return $model;
    }

    public function delete(CampaignInterface $model): bool
    {
        return $this->entityManager->delete($model);
    }
}
