<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.4.8
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\Email\Controller\Adminhtml;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Filter\Input;
use Magento\Framework\Registry;
use Mirasvit\Email\Api\Data\CampaignInterface;
use Mirasvit\Email\Repository\CampaignRepository;
use Mirasvit\Email\Controller\RegistryConstants;

abstract class Campaign extends Action
{
    /**
     * Authorization level of a basic admin session for current page.
     */
    const ADMIN_RESOURCE = 'Mirasvit_Email::campaign';

    protected $campaignRepository;

    protected $context;

    protected $registry;

    protected $dateTimeFilter;

    protected $inputFilter;

    public function __construct(
        \Magento\Framework\Stdlib\DateTime\Filter\DateTime $dateTimeFilter,
        Input $inputFilter,
        CampaignRepository $campaignRepository,
        Registry $registry,
        Context $context
    ) {
        $this->dateTimeFilter = $dateTimeFilter;
        $this->campaignRepository = $campaignRepository;
        $this->registry = $registry;
        $this->context = $context;
        $this->inputFilter = $inputFilter;

        parent::__construct($context);
    }

    /**
     * Init page
     *
     * @param \Magento\Backend\Model\View\Result\Page|\Magento\Framework\View\Result\Page $resultPage
     * @return \Magento\Backend\Model\View\Result\Page
     */
    protected function initPage($resultPage)
    {
        $resultPage->setActiveMenu('Magento_Backend::marketing');
        $resultPage->getConfig()->getTitle()->prepend((string)__('Follow Up Email'));
        $resultPage->getConfig()->getTitle()->prepend((string)__('Manage Campaigns'));

        return $resultPage;
    }

    /**
     * @return CampaignInterface
     */
    public function initModel()
    {
        $model = $this->campaignRepository->create();

        if ($this->getRequest()->getParam(CampaignInterface::ID)) {
            if ($model = $this->campaignRepository->get((int)$this->getRequest()->getParam(CampaignInterface::ID))) {
                $this->registry->register(RegistryConstants::CURRENT_CAMPAIGN_ID, $model->getId());
                $this->registry->register(RegistryConstants::CURRENT_MODEL, $model);
            }
        }

        return $model;
    }

    /**
     * @return bool
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed(self::ADMIN_RESOURCE);
    }
}
