<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.4.8
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\Email\Api\Data;

use Mirasvit\EmailDesigner\Api\Data\TemplateInterface;

interface QueueInterface
{
    const TABLE_NAME      = 'mst_email_queue';
    const ID              = 'queue_id';
    const TRIGGER_ID      = 'trigger_id';
    const STATUS          = 'status';
    const STATUS_MESSAGE  = 'status_message';
    const CHAIN_ID        = 'chain_id';
    const UNIQUE_KEY      = 'uniq_key';
    const UNIQUE_HASH     = 'uniq_hash';
    const SCHEDULED_AT    = 'scheduled_at';
    const SENT_AT         = 'sent_at';
    const ATTEMPTS_NUMBER = 'attemtps_number';
    const SENDER_EMAIL    = 'sender_email';
    const SENDER_NAME     = 'sender_name';
    const RECIPIENT_EMAIL = 'recipient_email';
    const RECIPIENT_NAME  = 'recipient_name';
    const SUBJECT         = 'subject';
    const CONTENT         = 'content';
    const ARGS            = 'args';
    const ARGS_SERIALIZED = 'args_serialized';
    const CREATED_AT      = 'created_at';
    const UPDATED_AT      = 'updated_at';
    const HISTORY         = 'history';


    const STATUS_PENDING      = 'pending';
    const STATUS_SENT         = 'sent';
    const STATUS_CANCELED     = 'canceled';
    const STATUS_UNSUBSCRIBED = 'unsubscribed';
    const STATUS_ERROR        = 'error';
    const STATUS_MISSED       = 'missed';

    public function getId();

    public function getTrigger(): TriggerInterface;

    public function getTriggerId(): int;

    public function setTriggerId(int $triggerId): self;

    public function getTemplate(): TemplateInterface;

    public function getStatus(): string;

    public function setStatus(string $status): self;

    public function getChainId(): int;

    public function setChainId(int $chainId): self;

    public function getUniqKey(): string;

    public function setUniqKey(string $uniqKey): self;

    public function getUniqHash(): string;

    public function setUniqHash(string $uniqHash): self;

    public function getScheduledAt(): string;

    public function setScheduledAt(string $scheduledAt): self;

    public function getSentAt(): ?string;

    public function setSentAt(string $sentAt = null): self;

    public function getAttemtpsNumber(): int;

    public function setAttemtpsNumber(int $attemtpsNumber): self;

    public function getSenderEmail(): string;

    public function setSenderEmail(string $senderEmail): self;

    public function getSenderName(): string;

    public function setSenderName(string $senderName): self;

    public function getRecipientEmail(): string;

    public function setRecipientEmail(string $recipientEmail): self;

    public function getRecipientName(): string;

    public function setRecipientName(string $recipientName): self;

    public function getContent(): ?string;

    public function setContent(string $content = null): self;

    public function getSubject(): string;

    public function setSubject(string $subject): self;

    /**
     * Get queue args.
     *
     * @param string $key
     *
     * @return array|string
     */
    public function getArgs(string $key = null);

    public function setArgs(array $args): self;

    public function getArgsSerialized(): string;

    public function setArgsSerialized(string $argsSerialized): self;

    public function getHistory(): string;

    public function setHistory(string $history): self;

    public function getCreatedAt(): string;

    public function setCreatedAt(string $createdAt): self;

    public function getUpdatedAt(): string;

    public function setUpdatedAt(string $updatedAt): self;

    /**
     * Send mail.
     */
    public function send(bool $force = false): self;

    /**
     * Change status to pending.
     */
    public function pending(string $message = ''): self;

    /**
     * Change status to delivery.
     */
    public function delivery(string $message = ''): self;

    /**
     * Change status to miss.
     */
    public function miss(string $message = ''): self;

    /**
     * Change status to unsubscribe.
     */
    public function unsubscribe(string $message = ''): self;

    /**
     * Change status to cancel.
     */
    public function cancel(string $message = ''): self;

    /**
     * Change status to error.
     */
    public function error(string $message = ''): self;

    /**
     * Save object data
     *
     * @return $this
     * @throws \Exception
     * @deprecated
     */
    public function save();

    /**
     * Load object data
     *
     * @param integer $modelId
     * @param null|string $field
     * @return $this
     * @deprecated
     */
    public function load($modelId, $field = null);

    /**
     * Delete object from database
     *
     * @return $this
     * @throws \Exception
     * @deprecated
     */
    public function delete();

    /**
     * Object data getter
     *
     * If $key is not defined will return all the data as an array.
     * Otherwise it will return value of the element specified by $key.
     * It is possible to use keys like a/b/c for access nested array data
     *
     * If $index is specified it will assume that attribute data is an array
     * and retrieve corresponding member. If data is the string - it will be explode
     * by new line character and converted to array.
     *
     * @param string     $key
     * @param string|int $index
     * @return mixed
     */
    public function getData($key = '', $index = null);

    /**
     * If $key is empty, checks whether there's any data in the object
     * Otherwise checks if the specified attribute is set.
     *
     * @param string $key
     * @return bool
     */
    public function hasData($key = '');

    /**
     * Overwrite data in the object.
     *
     * The $key parameter can be string or array.
     * If $key is string, the attribute value will be overwritten by $value
     *
     * If $key is an array, it will overwrite all the data in the object.
     *
     * @param string|array  $key
     * @param mixed         $value
     *
     * @return $this
     */
    public function setData($key, $value = null);

    /**
     * Add data to the object.
     *
     * Retains previous data in the object.
     *
     * @param array $arr
     *
     * @return $this
     */
    public function addData(array $arr);

    /**
     * Get object original data
     *
     * @param string $key
     * @return mixed
     */
    public function getOrigData($key = null);
}
