<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.4.9
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\EmailReport\Repository;

use Magento\Framework\EntityManager\EntityManager;
use Mirasvit\EmailReport\Api\Data\EmailInterface;
use Mirasvit\EmailReport\Api\Data\EmailInterfaceFactory;
use Mirasvit\EmailReport\Model\ResourceModel\Email\Collection;
use Mirasvit\EmailReport\Model\ResourceModel\Email\CollectionFactory;
use Magento\Framework\Stdlib\DateTime;

class EmailRepository
{
    private $entityManager;

    private $factory;

    private $collectionFactory;

    public function __construct(
        EmailInterfaceFactory $factory,
        CollectionFactory $collectionFactory,
        EntityManager $entityManager
    ) {
        $this->factory           = $factory;
        $this->collectionFactory = $collectionFactory;
        $this->entityManager     = $entityManager;
    }

    public function getCollection(): Collection
    {
        return $this->collectionFactory->create();
    }

    public function get(int $id): ?EmailInterface
    {
        $email = $this->create();
        $email = $this->entityManager->load($email, $id);

        return $email->getId() ? $email : null;
    }

    public function create(): EmailInterface
    {
        return $this->factory->create();
    }

    public function save(EmailInterface $email): EmailInterface
    {
        $email->setCreatedAt((new \DateTime())->format(DateTime::DATETIME_PHP_FORMAT));

        return $this->entityManager->save($email);
    }

    public function ensure(EmailInterface $email): EmailInterface
    {
        $size = $this->getCollection()
            ->addFieldToFilter(EmailInterface::QUEUE_ID, $email->getQueueId())
            ->getSize();

        if (!$size) {
            $this->save($email);
        }

        return $email;
    }

    public function delete(EmailInterface $email): bool
    {
        return $this->entityManager->delete($email);
    }
}
