<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.5.3
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\EmailDesigner\Controller\Adminhtml\Template;

use Magento\Backend\App\Action\Context;
use Magento\Framework\Registry;
use Mirasvit\EmailDesigner\Api\Data\TemplateInterface;
use Mirasvit\Email\Repository\Trigger\ChainRepository;
use Mirasvit\EmailDesigner\Controller\Adminhtml\Template;
use Mirasvit\EmailDesigner\Repository\TemplateRepository;
use Mirasvit\EmailDesigner\Model\Template as EmailTemplate;

class Delete extends Template
{
    public function __construct(
        ChainRepository    $chainRepository,
        TemplateRepository $templateRepository,
        Registry           $registry,
        Context            $context
    ) {
        $this->chainRepository = $chainRepository;

        parent::__construct($templateRepository, $registry, $context);
    }

    /**
     * {@inheritdoc}
     */
    public function execute()
    {
        /** @var \Magento\Framework\Controller\Result\Redirect $resultRedirect */
        $resultRedirect = $this->resultRedirectFactory->create();

        try {
            $template = $this->initModel();
            if ($template->isSystem()) {
                $this->messageManager->addErrorMessage((string)__('Sorry, but you cannot remove the default template.'));
                return $resultRedirect->setPath('*/*/', [
                    TemplateInterface::ID => $this->getRequest()->getParam(TemplateInterface::ID)
                ]);
            } elseif ($this->isUsed($template->getId()) === true) {
                $this->messageManager->addErrorMessage((string)__('Sorry, but you cannot remove template used in the trigger email chain.'));
                return $resultRedirect->setPath('*/*/', [

                    TemplateInterface::ID => $this->getRequest()->getParam(TemplateInterface::ID)
                ]);
            }

            $this->templateRepository->delete($template);
        } catch (\Exception $e) {
            $this->messageManager->addErrorMessage($e->getMessage());
            return $resultRedirect->setPath('*/*/', [
                TemplateInterface::ID => $this->getRequest()->getParam(TemplateInterface::ID)
            ]);
        }

        $this->messageManager->addSuccessMessage((string)__('Template was successfully deleted'));
        return $resultRedirect->setPath('*/*/');
    }

    public function isUsed($templateId)
    {
        $chainCollection = $this->chainRepository->getCollection();
        foreach ($chainCollection as $chain) {
            if ($chain->getTemplateId() == EmailTemplate::TYPE.':'.$templateId) {
              return true;
            }
        }

        return false;
    }
}
