<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.5.3
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\Email\Controller\Adminhtml;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Registry;
use Mirasvit\Email\Api\Data\QueueInterface;
use Mirasvit\Email\Model\QueueFactory;
use Mirasvit\Email\Repository\QueueRepository;

abstract class Queue extends Action
{
    protected $queueRepository;

    protected $registry;

    protected $context;

    public function __construct(
        QueueRepository $queueRepository,
        Registry        $registry,
        Context         $context
    ) {
        $this->queueRepository = $queueRepository;
        $this->registry        = $registry;
        $this->context         = $context;

        parent::__construct($context);
    }

    /**
     * Init page
     *
     * @param \Magento\Backend\Model\View\Result\Page $resultPage
     *
     * @return \Magento\Backend\Model\View\Result\Page
     */
    protected function initPage($resultPage)
    {
        $resultPage->setActiveMenu('Magento_Backend::marketing');
        $resultPage->getConfig()->getTitle()->prepend((string)__('Follow Up Email'));
        $resultPage->getConfig()->getTitle()->prepend((string)__('Mail Queue'));

        return $resultPage;
    }

    public function initModel(): QueueInterface
    {
        $model = $this->queueRepository->create();

        if ($this->getRequest()->getParam(QueueInterface::ID)) {
            $model->load((int)$this->getRequest()->getParam(QueueInterface::ID));
        }

        $this->registry->register('current_model', $model);

        return $model;
    }

    /**
     * {@inheritdoc}
     */
    protected function _isAllowed()
    {
        return $this->context->getAuthorization()->isAllowed('Mirasvit_Email::queue');
    }
}
