<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.5.3
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);

namespace Mirasvit\Email\Block\Adminhtml\Unsubscription\Edit;

use Magento\Backend\Block\Widget\Context;
use Magento\Backend\Block\Widget\Form as WidgetForm;
use Magento\Framework\Data\FormFactory;
use Magento\Framework\Registry;
use Mirasvit\Email\Model\Config\Source\TriggerSource;

class Form extends WidgetForm
{
    protected $formFactory;

    protected $registry;

    protected $triggers;

    public function __construct(
        FormFactory   $formFactory,
        Registry      $registry,
        Context       $context,
        TriggerSource $triggers
    ) {
        $this->formFactory = $formFactory;
        $this->registry    = $registry;
        $this->triggers    = $triggers;

        parent::__construct($context);
    }

    /**
     * {@inheritdoc}
     */
    protected function _prepareForm()
    {
        $form = $this->formFactory->create([
            'data' => [
                'id'      => 'edit_form',
                'action'  => $this->getUrl('*/*/unsubscribe', ['id' => $this->getRequest()->getParam('id')]),
                'method'  => 'post',
                'enctype' => 'multipart/form-data',
            ],
        ]);

        $general = $form->addFieldset('general', []);

        $general->addField('unsubscription_email', 'text', [
            'label'    => (string)__('Set emails via comma to unsubscribe'),
            'required' => true,
            'name'     => 'unsubscription_email',
        ]);

        $general->addField('trigger_ids', 'multiselect', [
            'name'     => 'trigger_ids',
            'label'    => (string)__('Triggers'),
            'required' => true,
            'values'   => $this->triggers->toOptionArray(),
        ]);

        $form->setAction($this->getUrl('*/*/unsubscribe'));
        $form->setUseContainer(true);
        $this->setForm($form);

        return parent::_prepareForm();
    }
}
