<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.3.0
 * @copyright Copyright (C) 2022 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\EmailReport\Service\MailModifier;

use Mirasvit\Email\Api\Data\QueueInterface;
use Magento\Framework\UrlInterface;
use Mirasvit\EmailReport\Service\StorageService;

class OpenModifier
{
    private $urlBuilder;


    public function __construct(
        UrlInterface $urlBuilder
    ) {
        $this->urlBuilder = $urlBuilder;
    }

    /**
     * @param QueueInterface $queue
     * @param string $content
     * @return string|string[]
     */
    public function modifyContent(QueueInterface $queue, $content)
    {
        $params = [
            StorageService::QUEUE_PARAM_NAME => $queue->getUniqHash(),
        ];

        $imgUrl = $this->urlBuilder->getUrl('emailreport/track/open', $params);

        $content = str_replace('</body>', '<img src="' . $imgUrl . '"></body>', $content);

        return $content;
    }
}
