<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.1.33
 * @copyright Copyright (C) 2019 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\Email\Model\Queue;

use Magento\Framework\Mail\TemplateInterface;

class TransportBuilder extends \Magento\Framework\Mail\Template\TransportBuilder
{
    /**
     * Set message subject
     *
     * @param string $subject
     *
     * @return $this
     */
    public function setSubject($subject)
    {
        $this->getTemplate()->setSubject($subject);

        return $this;
    }

    /**
     * Set message body
     *
     * @param string $body
     *
     * @return $this
     */
    public function setBody($body)
    {
        $this->getTemplate()->setBody($body);

        if (method_exists($this->message, 'setBodyHtml')) {
            $this->message->setBodyHtml($body);
        }

        return $this;
    }

    /**
     * Set from
     *
     * @param string $email
     * @param string $name
     *
     * @return $this
     */
    public function setFrom($email, $name = null)
    {
        $this->getTemplate()->setFrom($email, $name);

        if (method_exists($this, 'setFromByScope')) {
            $this->setFromByScope('general');
        }

        return $this;
    }

    /**
     * Set message type
     *
     * @param string $type
     *
     * @return $this
     */
    public function setMessageType($type)
    {
        $this->getTemplate()->setMessageType($type);

        return $this;
    }

    public function getTransport()
    {
        if ($this->message instanceof \Magento\Framework\Mail\MessageInterface) {
            // magento <= 2.3.2
            return parent::getTransport();
        } else {
            // magento 2.3.3+
            if ($this->message === null) {
                return $this;
            }

            return parent::getTransport();
        }
    }

    /**
     * @inheritdoc
     * Get template
     * @return TemplateInterface
     */
    protected function getTemplate()
    {
        if ($this->message == null || $this->message instanceof \Magento\Framework\Mail\EmailMessage) {
            $this->message = new Template();
        }

        return $this->message;
    }

    protected function prepareMessage()
    {
        if ($this->message instanceof \Magento\Framework\Mail\MessageInterface) {
            return $this;
        } else {
            return parent::prepareMessage();
        }
    }
}
