<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.4.6
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\EmailReport\Repository;

use Magento\Framework\EntityManager\EntityManager;
use Mirasvit\EmailReport\Api\Data\OpenInterface;
use Mirasvit\EmailReport\Api\Data\OpenInterfaceFactory;
use Mirasvit\EmailReport\Model\ResourceModel\Open\Collection;
use Mirasvit\EmailReport\Model\ResourceModel\Open\CollectionFactory;
use Magento\Framework\Stdlib\DateTime;

class OpenRepository
{
    private $entityManager;

    private $factory;

    private $collectionFactory;

    public function __construct(
        OpenInterfaceFactory $factory,
        CollectionFactory $collectionFactory,
        EntityManager $entityManager
    ) {
        $this->factory           = $factory;
        $this->collectionFactory = $collectionFactory;
        $this->entityManager     = $entityManager;
    }

    public function getCollection(): Collection
    {
        return $this->collectionFactory->create();
    }

    public function create(): OpenInterface
    {
        return $this->factory->create();
    }

    public function get(int $id): ?OpenInterface
    {
        $open = $this->factory->create();
        $open = $this->entityManager->load($open, $id);

        return $open->getId() ? $open : null;
    }

    public function save(OpenInterface $open): OpenInterface
    {
        $open->setCreatedAt((new \DateTime())->format(DateTime::DATETIME_PHP_FORMAT));

        return $this->entityManager->save($open);
    }

    public function ensure(OpenInterface $open): OpenInterface
    {
        $size = $this->getCollection()
            ->addFieldToFilter(OpenInterface::QUEUE_ID, $open->getQueueId())
            ->getSize();

        if (!$size) {
            $this->save($open);
        }

        return $open;
    }

    public function delete(OpenInterface $open): bool
    {
        return $this->entityManager->delete($open);
    }
}
