<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.4.6
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);

namespace Mirasvit\EmailDesigner\Service\TemplateEngine\Php\Variable;

use Magento\Framework\UrlInterface;
use Mirasvit\EmailDesigner\Service\TemplateEngine\Php\Variable\Context;
use Mirasvit\Email\Model\ConfigProvider;

class Url
{
    protected $urlBuilder;

    protected $context;

    private $config;

    public function __construct(
        UrlInterface $urlBuilder,
        Context $context,
        ConfigProvider $config
    ) {
        $this->urlBuilder = $urlBuilder;
        $this->context    = $context;
        $this->config     = $config;
    }

    public function getRestoreCartUrl(): string
    {
        return $this->getUrl('email/action/restoreCart');
    }

    public function getReorderCartUrl(): string
    {
        return $this->getUrl('email/action/reorder');
    }

    /**
     * Resume customer's session, before redirecting to target URL.
     */
    public function getResumeUrl(string $to = null): string
    {
        $params = [];
        if ($to) {
            $params['to'] = base64_encode($to);
        }

        return $this->getUrl('email/action/resume', $params);
    }

    public function getCheckoutUrl(): string
    {
        return $this->getUrl('email/action/checkout');
    }

    public function getViewInBrowserUrl(): string
    {
        return $this->getUrl('email/action/view');
    }

    public function getUnsubscribeUrl(): string
    {
        return $this->getUrl('email/action/unsubscribe');
    }

    public function getUnsubscribeAllUrl(): string
    {
        return $this->getUrl('email/action/unsubscribeAll');
    }

    public function getFacebookUrl(): string
    {
        return $this->config->getFacebookUrl();
    }

    public function getTwitterUrl(): string
    {
        return $this->config->getTwitterUrl();
    }

    protected function getUrl(string $route, array $params = []): string
    {
        /** @var \Magento\Store\Model\Store $store */
        $store = $this->context->getStore();

        if ($this->context->getQueue() && $store) {
            $hash = $this->context->getQueue()->getUniqHash();

            $params = array_merge(['hash' => $hash], $params);

            return $store->getBaseUrl() . $route . '?' . http_build_query($params);
        } else {
            return '';
        }
    }
}
