<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.4.6
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\Email\Ui\Campaign\View\Control;

use Magento\Framework\Url;
use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;
use Mirasvit\Email\Api\Data\ChainInterface;
use Mirasvit\Email\Service\FrontSessionInitiator;

class SendTestButton extends GenericButton implements ButtonProviderInterface
{
    private $config;
    private $urlBuilder;
    private $FrontSessionInitiator;
    private $formKey;

    private $storeManager;


    public function __construct(
        \Mirasvit\Email\Model\ConfigProvider $config,
        \Magento\Backend\Block\Widget\Context $context,
        \Magento\Framework\Registry $registry,
        Url $urlBuilder,
        FrontSessionInitiator $FrontSessionInitiator
    ) {
        $this->storeManager = $context->getStoreManager();
        $this->formKey = $context->getFormKey();
        $this->config = $config;
        $this->urlBuilder = $urlBuilder;
        $this->FrontSessionInitiator = $FrontSessionInitiator;

        parent::__construct($context, $registry);
    }

    /**
     * {@inheritDoc}
     */
    public function getButtonData()
    {
        $data = [];
        $chainId = $this->context->getRequest()->getParam(ChainInterface::ID);

        if ($chainId) {
            $data = [
                'label' =>(string)__('Send Test Email'),
                'sort_order' => 5,
                'on_click' => 'trigger.sendTestEmail(
                    this,
                    false,
                    \'' . $this->config->getTestEmail() . '\',
                    \'' . $this->getSendUrl() . '\'
                )',
                'data_attribute' => [
                    'mage-init' => [
                        'trigger' => []
                    ],
                ],
            ];
        }

        return $data;
    }

    /**
     * @return string
     */
    public function getSendUrl()
    {
        // init front session to make possible to send emails
        //$this->FrontSessionInitiator->set($this->formKey->getFormKey());
        $storeId = $this->storeManager->getDefaultStoreView()->getId();

        return $this->urlBuilder->getUrl('email/action/send/', [
            '_scope' => $storeId,
            ChainInterface::ID => $this->context->getRequest()->getParam(ChainInterface::ID)
        ]);
    }
}
