<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.4.6
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);

//@codingStandardsIgnoreFile
namespace Mirasvit\Email\Helper;

use Magento\Customer\Model\CustomerFactory;
use Magento\Quote\Model\QuoteFactory;
use Magento\Sales\Model\OrderFactory;
use Magento\Customer\Model\ResourceModel\Customer\CollectionFactory as CustomerCollectionFactory;
use Magento\Quote\Model\ResourceModel\Quote\CollectionFactory as QuoteCollectionFactory;
use Magento\Sales\Model\ResourceModel\Order\CollectionFactory as OrderCollectionFactory;
use Mirasvit\Email\Model\ConfigProvider;
use Magento\Framework\App\Helper\Context;
use Magento\Store\Model\StoreManagerInterface;

class Event extends \Magento\Framework\App\Helper\AbstractHelper
{
    protected $customerFactory;

    protected $quoteFactory;

    protected $orderFactory;

    protected $customerCollectionFactory;

    protected $quoteCollectionFactory;

    protected $orderCollectionFactory;

    protected $config;

    protected $storeManager;

    public function __construct(
        CustomerFactory $customerFactory,
        QuoteFactory $quoteFactory,
        OrderFactory $orderFactory,
        CustomerCollectionFactory $customerCollectionFactory,
        QuoteCollectionFactory $quoteCollectionFactory,
        OrderCollectionFactory $orderCollectionFactory,
        ConfigProvider $config,
        Context $context,
        StoreManagerInterface $storeManager
    ) {
        $this->customerFactory           = $customerFactory;
        $this->quoteFactory              = $quoteFactory;
        $this->orderFactory              = $orderFactory;
        $this->customerCollectionFactory = $customerCollectionFactory;
        $this->quoteCollectionFactory    = $quoteCollectionFactory;
        $this->orderCollectionFactory    = $orderCollectionFactory;
        $this->config                    = $config;
        $this->storeManager              = $storeManager;

        parent::__construct($context);
    }

    public function getRandomEventArgs(): array
    {
        $customerCollection = $this->customerCollectionFactory->create();
        $customerCollection->getSelect()->limit(1, rand(0, $customerCollection->getSize() - 1));
        $customer = $this->customerFactory->create()->load($customerCollection->getFirstItem()->getId());

        $quoteCollection = $this->quoteCollectionFactory->create()
            ->addFieldToFilter('items_qty', ['gt' => 0]);
        $quoteCollection->getSelect()->limit(1, rand(0, $quoteCollection->getSize() - 1));
        $quote = $this->quoteFactory->create()->setSharedStoreIds(array_keys($this->storeManager->getStores()))
            ->load($quoteCollection->getFirstItem()->getId());

        $orderCollection = $this->orderCollectionFactory->create();
        $orderCollection->getSelect()->limit(1, rand(0, $orderCollection->getSize() - 1));
        $order = $this->orderFactory->create()->load($orderCollection->getFirstItem()->getId());

        $testEmail = $this->config->getTestEmail();

        $store = $this->storeManager->getWebsite(true)
            ->getDefaultGroup()
            ->getDefaultStore();

        $args = [
            'customer_id'    => $customer->getId(),
            'customer_email' => $testEmail,
            'customer_name'  => $customer->getName(),
            'quote_id'       => $quote->getId(),
            'order_id'       => $order->getId(),
            'ts'             => time(),
            'store_id'       => $store->getId(),
        ];

        return $args;
    }
}
