<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.4.6
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\Email\Controller\Adminhtml\Campaign;

use Magento\Framework\Model\AbstractModel;
use Mirasvit\Email\Api\Data\TriggerInterface;
use Mirasvit\Email\Repository\TriggerRepository;
use Mirasvit\Email\Controller\Adminhtml\Campaign;
use Mirasvit\Email\Api\Data\CampaignInterface;
use Mirasvit\Email\Api\Data\ChainInterface;
use Mirasvit\Email\Repository\Trigger\ChainRepository;
use Mirasvit\Email\Service\CloneService;

class Duplicate extends Campaign
{
    /**
     * {@inheritdoc}
     */
    public function execute()
    {
        $resultRedirect = $this->resultRedirectFactory->create();

        if ($data = $this->getRequest()->getParams()) {
            $model = $this->campaignRepository->get((int)$this->getRequest()->getParam(CampaignInterface::ID));

            try {
                $this->duplicate($model);

                $this->messageManager->addSuccessMessage((string)__('Campaign was successfully duplicated.'));

                return $resultRedirect->setPath('*/*/');
            } catch (\Exception $e) {
                $this->messageManager->addErrorMessage($e->getMessage());
                return $resultRedirect->setPath('*/*/');
            }
        }

        $this->messageManager->addErrorMessage((string)__('Unable to find campaign to duplicate'));

        return $resultRedirect->setPath('*/*/');
    }

    /**
     * @param CampaignInterface $campaign
     *
     * @return AbstractModel
     */
    private function duplicate(CampaignInterface $campaign)
    {
        /** @var CloneService $clonner */
        $clonner = $this->_objectManager->get(CloneService::class);

        $campaignClone = $clonner->duplicate($campaign, $this->campaignRepository, [
            CampaignInterface::ID,
            CampaignInterface::CREATED_AT,
            CampaignInterface::UPDATED_AT
        ]);

        /** @var TriggerRepository $triggerRepository */
        $triggerRepository = $this->_objectManager->get(TriggerRepository::class);
        /** @var ChainRepository $chainRepository */
        $chainRepository = $this->_objectManager->get(ChainRepository::class);

        // Retrieve triggers related with original campaign
        $triggerCollection = $triggerRepository->getCollection();
        $triggerCollection->addFieldToFilter(CampaignInterface::ID, $campaign->getId());

        // Duplicate triggers for campaign clone
        /** @var TriggerInterface $trigger */
        foreach ($triggerCollection as $trigger) {
            $triggerClone = $clonner->duplicate($trigger, $triggerRepository, [
                TriggerInterface::ID,
                TriggerInterface::CREATED_AT,
                TriggerInterface::UPDATED_AT
            ], [CampaignInterface::ID => $campaignClone->getId()]);

            // duplicate chains for trigger clone
            /** @var ChainInterface $chain */
            foreach ($trigger->getChainCollection() as $chain) {
                $clonner->duplicate($chain, $chainRepository, [
                    ChainInterface::ID,
                    ChainInterface::CREATED_AT,
                    ChainInterface::UPDATED_AT
                ], [TriggerInterface::ID => $triggerClone->getId()]);
            }
        }

        return $campaignClone;
    }
}
