<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.1.0
 * @copyright Copyright (C) 2018 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\Email\Setup\Upgrade;


use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\UpgradeDataInterface;
use Mirasvit\Email\Api\Repository\Trigger\ChainRepositoryInterface;

class UpgradeData113 implements UpgradeDataInterface, VersionableInterface
{
    const VERSION = '1.1.3';
    /**
     * @var ChainRepositoryInterface
     */
    private $chainRepository;

    public function __construct(ChainRepositoryInterface $chainRepository)
    {
        $this->chainRepository = $chainRepository;
    }

    /**
     * {@inheritdoc}
     */
    public function getVersion()
    {
        return self::VERSION;
    }

    /**
     * {@inheritDoc}
     */
    public function upgrade(ModuleDataSetupInterface $setup, ModuleContextInterface $context)
    {
        $this->createCampaigns();
    }

    /**
     * Create campaigns based on existing triggers.
     */
    private function createCampaigns()
    {
        foreach ($this->chainRepository->getCollection() as $chain) {
            $chain->setTemplateId('emaildesigner:'.$chain->getTemplateId());
            $this->chainRepository->save($chain);
        }
    }
}
