<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.2.1
 * @copyright Copyright (C) 2022 Mirasvit (https://mirasvit.com/)
 */


namespace Mirasvit\Email\Setup\Patch\Data;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\Patch\PatchVersionInterface;
use Mirasvit\Email\Api\Repository\Trigger\ChainRepositoryInterface;
use Mirasvit\Email\Helper\Serializer;
use Mirasvit\Email\Model\ResourceModel\Trigger\Chain\Collection as ChainCollection;
use Mirasvit\Email\Model\Trigger\Chain;


class DataPatch104 implements DataPatchInterface, PatchVersionInterface
{
    private $setup;
    private $chainRepository;
    private $serializer;

    public function __construct(
        ModuleDataSetupInterface $setup,
        ChainRepositoryInterface $chainRepository,
        Serializer               $serializer
    ) {
        $this->setup = $setup;
        $this->chainRepository = $chainRepository;
        $this->serializer = $serializer;
    }

    /**
     * @inheritdoc
     */
    public function apply()
    {
        $this->setup->getConnection()->startSetup();
        $installer = $this->setup;

        /** @var ChainCollection $chainCollection */
        $chainCollection = $this->chainRepository->getCollection()->loadData();
        /** @var Chain $chain */
        foreach ($chainCollection as $chain) {
            $delay = $this->getSerializedChainData($chain);

            if ($delay->getRange() == 'year') {
                $days = $delay->getFrequency() * 365;
            } elseif ($delay->getRange() == 'month') {
                $days = $delay->getFrequency() * 30;
            } elseif ($delay->getRange() == 'week') {
                $days = $delay->getFrequency() * 7;
            } else {
                $days = $delay->getFrequency();
            }

            $excludeDays = $delay->getExcludeDays();
            if (!is_array($excludeDays)) {
                $excludeDays = [];
            }

            $chain->setDay($days)
                ->setHour($delay->getHours())
                ->setMinute($delay->getMinutes())
                ->setExcludeDays(implode(',', $excludeDays));

            // update send_from - send_to
            if ($chain->getType() == 'at') {
                if ($chain->getHour() > 0) {
                    $chain->setSendFrom($chain->getHour() - 1);
                } else {
                    $chain->setSendFrom(0);
                }

                $chain->setSendTo(($chain->getHour() + 2) % 24);
            }

            $chain->save();
        }
        $this->setup->getConnection()->endSetup();
    }

    /**
     * {@inheritdoc}
     */
    public static function getVersion(): string
    {
        return '1.0.4';
    }


    /**
     * {@inheritdoc}
     */
    public static function getDependencies() {
        return [DataPatch102::class];
    }

    /**
     * {@inheritdoc}
     */
    public function getAliases() {
        return [];
    }
}
