define([
    'jquery',
    'Magento_Ui/js/form/element/abstract',
    'editor'
], function($, Component, editor) {
    'use strict';

    /*function initEditor(url) {
        editor({
            url: url
        });
    }

    $('#email-designer__preview').ready(function() {
        initEditor();
    });*/

    return Component.extend({
        defaults: {
            autoRefresh: false
        },

        initialize: function() {
            this._super()
                //.updatePreview()
            ;

            return this;
        },


        initObservable: function () {
            this._super()
                .observe({
                    autoRefresh: false
                });

            return this;
        },

        toDesktop: function() {
            editor().changeView('desktop');
        },

        toMobile: function() {
            editor().changeView('mobile');
        },

        /**
         * Change refresh mode.
         */
        changeRefreshMode: function() {
            this.autoRefresh(!this.autoRefresh());
            editor().autoRefresh = this.autoRefresh();
        },

        refresh: function() {
            editor().updatePreview();
        },

        updatePreview: function() {
            editor().updatePreview();
        }
    });
});