<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email-designer
 * @version   1.1.12
 * @copyright Copyright (C) 2018 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\EmailDesigner\Service;


use Mirasvit\EmailDesigner\Api\Data\TemplateInterface;
use Mirasvit\EmailDesigner\Api\Service\TemplateEngineInterface;
use Mirasvit\EmailDesigner\Api\Service\TemplateProcessorInterface;

class TemplateProcessor implements TemplateProcessorInterface
{
    /**
     * @var array|\Mirasvit\EmailDesigner\Api\Service\TemplateEngineInterface[]
     */
    private $templateEngines;

    /**
     * TemplateProcessor constructor.
     *
     * @param TemplateEngineInterface[] $templateEngines
     */
    public function __construct(array $templateEngines = [])
    {
        $this->templateEngines = $templateEngines;
    }

    /**
     * {@inheritdoc}
     */
    public function process(TemplateInterface $template, $tpl, array $variables = [])
    {
        // set template areas as variables
        foreach ($template->getTemplateAreas() as $code => $text) {
            $variables['area_' . $code] = $text;
        }

        foreach ($this->templateEngines as $templateEngine) {
            $tpl = $templateEngine->render($tpl, $variables);
        }

        return $tpl;
    }
}
