<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email-designer
 * @version   1.1.0
 * @copyright Copyright (C) 2018 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\EmailDesigner\Service\TemplateEngine\Liquid\Variable;


class Item extends AbstractVariable
{
    /**
     * List of classes for this variable.
     *
     * @var string[]
     */
    protected $supportedTypes = [
        'Magento\Sales\Model\Order\Item',
        'Magento\Quote\Model\Quote\Item',
        //'Mirasvit\EmailDesigner\Service\TemplateEngine\Liquid\Variable\Product'
    ];

    /**
     * List of allowed methods.
     *
     * @var string[]
     */
    protected $whitelist = [
        'getQtyOrdered',
    ];

    /**
     * @var Product
     */
    private $productVariable;

    /**
     * @var Quote
     */
    private $quoteVariable;

    /**
     * @var Order
     */
    private $orderVariable;

    /**
     * Item constructor.
     *
     * @param Product $productVariable
     */
    public function __construct(
        Order $orderVariable,
        Quote $quoteVariable,
        Product $productVariable
    ) {
        $this->orderVariable = $orderVariable;
        $this->quoteVariable = $quoteVariable;
        $this->productVariable = $productVariable;
    }

    /**
     * {@inheritdoc}
     */
    public function getVariableName()
    {
        return __('Order/Quote Item');
    }

    /** VARIABLES **/

    /**
     * Get name
     *
     * @return float
     */
    public function getName()
    {
        $result = '';
        if ($item = $this->context->getData('item')) {
            $result = $item->getName();
        }

        return $result;
    }

    /**
     * Get price including tax
     *
     * @filter | format_price
     *
     * @return float
     */
    public function getPriceInclTax()
    {
        $result = '';
        if ($item = $this->context->getData('item')) {
            $result = $item->getPriceInclTax();
        }

        return $result;
    }

    /**
     * Get price
     *
     * @filter | format_price
     *
     * @return float
     */
    public function getPrice()
    {
        $result = '';
        if ($item = $this->context->getData('item')) {
            $result = $item->getPrice();
        }

        return $result;
    }

    /**
     * Get product image url
     *
     * @namespace item.product
     * @filter | resize: 'image', 300
     *
     * @return string
     */
    public function getImage()
    {
        $result = '';
        if ($item = $this->context->getData('item')) {
            $result = $this->productVariable->getImage($item->getProduct());
        }

        return $result;
    }

    /**
     * Get product url
     *
     * @namespace item.product
     *
     * @return string
     */
    public function getProductUrl()
    {
        $result = '';
        /** @var \Magento\Quote\Model\Quote\Item $item */
        if ($item = $this->context->getData('item')) {
            $result = $item->getProduct()->getProductUrl();
        }

        return $result;
    }

    /**
     * Get array of all items that can be displayed
     *
     * @namespace this
     *
     * @return \Magento\Sales\Model\Order\Item[]
     */
    public function getAllVisibleItems()
    {
        $items = [];
        if ($order = $this->orderVariable->setContext($this->context)->getOrder()) {
            $items = $order->getAllVisibleItems();
        } elseif ($quote = $this->quoteVariable->setContext($this->context)->getQuote()) {
            $items = $quote->getAllVisibleItems();
        }

        return $items;
    }
}
