<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email-designer
 * @version   1.1.0
 * @copyright Copyright (C) 2018 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\EmailDesigner\Block\Adminhtml\Template\Edit;


use Magento\Backend\Block\Template;
use Magento\Framework\Registry;
use Mirasvit\EmailDesigner\Api\Data\TemplateInterface;
use Mirasvit\EmailDesigner\Controller\RegistryConstants;

class Editor extends Template
{

    /**
     * Template editor template name.
     *
     * @var string
     */
    protected $_template = 'Mirasvit_EmailDesigner::template/editor.phtml';

    /**
     * @var Registry
     */
    private $registry;

    public function __construct(
        Registry $registry,
        \Magento\Backend\Block\Template\Context $context,
        array $data = []
    ) {
        parent::__construct($context, $data);

        $this->registry = $registry;
    }

    /**
     * @return TemplateInterface|null
     */
    public function getModel()
    {
        return $this->registry->registry(RegistryConstants::CURRENT_MODEL);
    }
}
