<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email-designer
 * @version   1.1.9
 * @copyright Copyright (C) 2018 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\EmailDesigner\Controller\Adminhtml\Theme;

use Mirasvit\EmailDesigner\Controller\Adminhtml\Theme;
use Mirasvit\EmailDesigner\Api\Data\ThemeInterface;
use \Mirasvit\EmailDesigner\Service\TemplateEngine\Php\Variable\Pool as VariablePool;

class Drop extends Theme
{
    /**
     * {@inheritdoc}
     */
    public function execute()
    {
        $model = $this->initModel();

        if (strpos($_SERVER['HTTP_HOST'], 'm2.mirasvit.com') === false) {
            foreach ($this->getRequest()->getParam(ThemeInterface::THEME_AREAS) as $key => $value) {
                $model->setDataUsingMethod($key, $value);
            }
        }

        /** @var VariablePool $variablePool */
        $variablePool = $this->_objectManager->get(VariablePool::class);
        $variables = $variablePool->getRandomVariables();
        $variables['preview'] = true;
        $this->getResponse()->setBody($model->getProcessedTemplateText($variables));
    }

    /**
     * {@inheritdoc}
     */
    public function _processUrlKeys()
    {
        return true;
    }
}
