<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-core
 * @version   1.2.29
 * @copyright Copyright (C) 2017 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\Core\Controller\Lc;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Mirasvit\Core\Model\ModuleFactory;

class Index extends Action
{
    /**
     * @var ModuleFactory
     */
    private $moduleFactory;

    public function __construct(
        ModuleFactory $moduleFactory,
        Context $context
    ) {
        $this->moduleFactory = $moduleFactory;

        parent::__construct($context);
    }

    /**
     * {@inheritdoc}
     * @SuppressWarnings(PHPMD)
     */
    public function execute()
    {
        echo '<pre>';
        $module = $this->moduleFactory->create();
        foreach ($module->getInstalledModules() as $moduleName) {
            echo substr($moduleName, 9);

            $info = $module->getComposerInformation($moduleName);
            if ($info) {
                echo ' ' . $info['version'];
            }

            echo PHP_EOL;
        }

        exit;
    }
}
