<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-core
 * @version   1.3.0
 * @copyright Copyright (C) 2021 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);

namespace Mirasvit\Core\Controller\Adminhtml\QuickDataBar;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\ObjectManagerInterface;
use Mirasvit\Core\Service\SerializeService;

class Load extends Action
{
    private $objectManager;

    public function __construct(
        ObjectManagerInterface $objectManager,
        Context                $context
    ) {
        $this->objectManager = $objectManager;

        parent::__construct($context);
    }

    public function execute(): void
    {
        $class     = (string)$this->getRequest()->getParam('block');
        $dataBlock = $this->objectManager->create($class);

        $from = new \DateTime((string)$this->getRequest()->getParam('from'));
        $to   = new \DateTime((string)$this->getRequest()->getParam('to'));

        $result = $dataBlock
            ->setDateRange($from, $to)
            ->toArray();

        /** @var \Magento\Framework\App\Response\Http $response */
        $response = $this->getResponse();

        $response->representJson(SerializeService::encode([
            'success' => true,
            'data'    => $result,
        ]));
    }

    protected function _isAllowed(): bool
    {
        return true;
    }
}
