define(
    [
        'jquery',
        'ko',
        'uiComponent',
        'jquery/file-uploader',
        'Magento_Checkout/js/model/full-screen-loader',
        'Magento_Ui/js/modal/alert',

    ],
    function ($, ko, Component, jQfileUpload, fullScreenLoader, alert) {
        'use strict';
        var quoteData = window.checkoutConfig.quoteData;
        var mediaPath = window.checkoutConfig.orderupload.mediaPath;
        var removeUrl = window.checkoutConfig.orderupload.removeUrl;
        var enabledModule = window.checkoutConfig.orderupload.enabledModule;
        var allowedSize = window.checkoutConfig.orderupload.allowedSize;
        var maxFileSize = window.checkoutConfig.orderupload.maxFileSize;
        var allowComment = window.checkoutConfig.orderupload.allowComment;
        var extArray = allowedSize.split(',');
        ko.bindingHandlers.fileUpload = {
            init: function (element, valueAccessor) {
                console.log('files.js called');
                if (quoteData.file_data) {
                    var fileObj = $.parseJSON(quoteData.file_data);

                    var fileUrl = mediaPath + fileObj['file'];
                    jQuery('div.filePreview').html('<p><a target="_blank" href="' + fileUrl + '">' + fileObj['name'] + '</a><span class="remove-btn"><a href="' + removeUrl + '">Remove</a></span></p>');
                }
                $('#fileupload').fileupload({
                    add: function (e, data) {
                        console.log('files.js fileupload called');
                        console.log(jQuery('#comment').val());
                        var uploadErrors = [];

                        var ext = data.originalFiles[0].name.split('.').pop().toLowerCase();
                        if ($.inArray(ext, extArray) == -1) {
                            uploadErrors.push('The file you attached is not valid, try again with a valid file type attachment.');
                        }
                        if (data.originalFiles[0].size > (maxFileSize * 1024 * 1024)) {//2 MB
                            uploadErrors.push('Filesize is too big');
                        }
                        if (uploadErrors.length > 0) {
                            alert({
                                title: 'Error',
                                content: uploadErrors.join("\n"),
                                actions: {
                                    always: function () {
                                    }
                                }
                            });
                        } else {
                            data.submit();
                        }
                    },
                    start: function (e) {
                        fullScreenLoader.startLoader();
                    },
                    dataType: 'json',
                    url: window.checkoutConfig.orderupload.uploadUrl,
                    done: function (e, data) {
                        var fileUrl = data.result.path + data.result.file;
                        jQuery('div.filePreview').html('<p><a href="' + fileUrl + '">' + data.result.name + '</a><span class="remove-btn"><a href="' + removeUrl + '">Remove</a></span></p>');
                        fullScreenLoader.stopLoader();
                    }
                });
            },
        };
        return Component.extend({
            defaults: {
                template: 'Meetanshi_OrderUpload/orderupload/files'
            },
            canVisibleFileUpload: enabledModule,
            canAllowComment: allowComment,
        });
    }
);
