<?php

namespace Meetanshi\OrderUpload\Observer;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Json\Helper\Data;
use Meetanshi\OrderUpload\Helper\Data as HelperData;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Quote\Model\QuoteFactory;

class SetEmailTemplateVariables implements ObserverInterface
{
    protected $jsonHelper;
    protected $helper;
    protected $scopeConfig;
    protected $quoteFactory;
    protected $storeInterface;

    public function __construct(HelperData $helper, Data $jsonHelper, StoreManagerInterface $storeInterface, QuoteFactory $quoteFactory)
    {
        $this->helper = $helper;
        $this->jsonHelper = $jsonHelper;
        $this->quoteFactory = $quoteFactory;
        $this->storeInterface = $storeInterface;
    }

    public function execute(Observer $observer)
    {
        $quoteId = $observer->getEvent()->getTransport()->getOrder()->getQuoteId();
        $transport = $observer->getEvent()->getTransport();
        $quote = $this->quoteFactory->create()->load($quoteId);
        $fileData = $quote->getFileData();
        if (isset($fileData) && !empty($fileData) && $this->helper->sendEmailSeperately() == 2 && $this->helper->isSendEmail() && $this->helper->addAttachmentInEmail())
        {
            $transport->setData('file_attach', 1);
            $fileData = $this->jsonHelper->jsonDecode($fileData);
            $fileName = $fileData['name'];
            $transport->setData('file_name', $fileName);
            $transport->setData('file_path', $fileData['file']);
        } else {
            $transport->setData('file_attach', 0);
        }
    }
}
