<?php

namespace Meetanshi\OrderUpload\Observer;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Json\Helper\Data;
use Meetanshi\OrderUpload\Helper\Data as HelperData;
use Meetanshi\OrderUpload\Model\OrderUploadFactory;
use Meetanshi\OrderUpload\Helper\Email as EmailData;

class SalesOrderPlaceAfter implements ObserverInterface
{
    protected $jsonHelper;
    protected $orderUploadFactory;
    protected $emailData;
    protected $helper;
    protected $request;

    public function __construct(\Magento\Framework\App\RequestInterface $request, HelperData $helper, Data $jsonHelper, OrderUploadFactory $orderUploadFactory, EmailData $emailData)
    {
        $this->helper = $helper;
        $this->jsonHelper = $jsonHelper;
        $this->orderUploadFactory = $orderUploadFactory;
        $this->emailData = $emailData;
        $this->request = $request;
    }

    public function execute(Observer $observer)
    {
        $order = $observer->getEvent()->getOrder();
        $quote = $observer->getEvent()->getQuote();
        $comment = $quote->getData('order_comment');
        $fileData = $quote->getData('file_data');
        if (!empty($fileData)) {
            $fileData = $this->jsonHelper->jsonDecode($fileData);
            $model = $this->orderUploadFactory->create();
            $time = time();
            $model->setCreatedAt($time);
            $model->setUpdatedAt($time);
            $model->setComment($comment);
            $model->setOrderId($order->getId());
            $model->setCustomerId($order->getCustomerId());
            $model->setFileName($fileData['name']);
            $model->setFilePath($fileData['file']);
            $model->save();

            if ($this->helper->isSendEmail() && $this->helper->sendEmailSeperately() == 1) {
                $adminEmail = $this->helper->getAdminEmail();
                $adminName = $this->helper->getAdminName();

                $firstName = $order->getBillingAddress()->getFirstName();
                $lastName = $order->getBillingAddress()->getLastName();

                $sender = ['name' => $firstName . ' ' . $lastName, 'email' => $order->getCustomerEmail(),];
                $receiver = ['name' => $adminName, 'email' => $adminEmail,];

                $fileName = $fileData['name'];
                $pubMediaUrl = $this->helper->pubMediaPath();
                $file = file_get_contents($pubMediaUrl . $fileData['file']);
                $dataArray = [];
                $dataArray[] = $fileName . "=>" . $file;
                $emailTempVariables = [];
                $emailTempVariables['order_id'] = $order->getIncrementId();
                $emailTempVariables['update'] = "customer";
                $emailTempVariables['name'] = $firstName . " " . $lastName;
                $emailTempVariables['email'] = $order->getCustomerEmail();
                $this->emailData->customMailSendMethod($emailTempVariables, $sender, $receiver, $dataArray);
            }
            return $this;
        }
    }
}
