<?php

namespace Meetanshi\OrderUpload\Model;

use Meetanshi\OrderUpload\Helper\Data;
use Magento\Checkout\Model\ConfigProviderInterface;
use Magento\Framework\UrlInterface;

class OrderUploadConfigProvider implements ConfigProviderInterface
{
    const SYSTEM_PATH_MODULE_ENABLE = 'orderupload/general/enabled';

    protected $helper;
    protected $urlBuilder;

    public function __construct(UrlInterface $urlBuilder, Data $helper)
    {
        $this->urlBuilder = $urlBuilder;
        $this->helper = $helper;
    }

    public function getConfig()
    {

        return ['orderupload' => ['uploadUrl' => $this->urlBuilder->getUrl('orderupload/upload/checkout'), 'removeUrl' => $this->urlBuilder->getUrl('orderupload/upload/remove'), 'enabledModule' => $this->check(), 'allowedSize' => $this->helper->getFileExtensions(), 'maxFileSize' => $this->helper->getMaxFileSize(), 'mediaPath' => $this->helper->pubMediaPath(), 'allowComment' => $this->checkComment()]];
    }

    public function check()
    {
        $moduleEnabled = $this->helper->getStoreConfig(self::SYSTEM_PATH_MODULE_ENABLE);
        $valid = $this->helper->isValidCustomerGroup();
        $allowOnCheckout = $this->helper->allowOnCheckout();
        if ($moduleEnabled && $valid && $allowOnCheckout) {
            return true;
        }
        return false;
    }

    public function checkComment()
    {
        $moduleEnabled = $this->helper->getStoreConfig(self::SYSTEM_PATH_MODULE_ENABLE);
        $allowOnCheckout = $this->helper->allowOnCheckout();
        $comment = $this->helper->addCommentFromCheckout();
        if($allowOnCheckout && $comment && $moduleEnabled) {
            return true;
        }
        return false;
    }
}
