<?php

namespace Meetanshi\OrderUpload\Model\OrderUpload;

use Meetanshi\OrderUpload\Helper\Data;
use Magento\Framework\File\Uploader;

class FileUploader extends Uploader
{
    protected $_allowRenameFiles = false;
    protected $_enableFilesDispersion = true;
    protected $_allowedExtensions = null;
    protected $helper;

    public function __construct($fileId, Data $helper)
    {
        parent::__construct($fileId);
        $this->helper = $helper;
    }

    protected function _afterSave($result)
    {
        $this->_result['text_file_size'] = $this->helper->getDOCFileSize($this->_file['size']);
        return parent::_afterSave($result);
    }
}
