<?php

namespace Meetanshi\OrderUpload\Model\Order\Email;

use Meetanshi\OrderUpload\Helper\Template\TransportBuilder;
use Magento\Sales\Model\Order\Email\Container\IdentityInterface;
use Magento\Sales\Model\Order\Email\Container\Template;
use Magento\Sales\Model\Order\Email\SenderBuilder as OrderSenderBuilder;
use Meetanshi\OrderUpload\Helper\Data as DataHelper;

class SenderBuilder extends OrderSenderBuilder
{
    public function __construct(Template $templateContainer, IdentityInterface $identityContainer, TransportBuilder $transportBuilder, DataHelper $helper)
    {
        parent::__construct($templateContainer, $identityContainer, $transportBuilder);
        $this->helper = $helper;
    }

    protected function configureEmailTemplate()
    {
        $this->transportBuilder->setTemplateIdentifier($this->templateContainer->getTemplateId());
        $this->transportBuilder->setTemplateOptions($this->templateContainer->getTemplateOptions());
        $this->transportBuilder->setTemplateVars($this->templateContainer->getTemplateVars());
        $this->transportBuilder->setFrom($this->identityContainer->getEmailIdentity());
        $vars = $this->templateContainer->getTemplateVars();
        if (isset($vars['file_attach'])) {
            $fileAttach = $vars['file_attach'];
            if ($fileAttach == 1) {
                $fileName = $vars['file_name'];
                $pubMediaUrl = $this->helper->tempMediaPath();
                $filePath = $vars['file_path'];
                $file = file_get_contents($pubMediaUrl . $filePath);
                $this->transportBuilder->addAttachment($file, \Zend_Mime::TYPE_OCTETSTREAM, \Zend_Mime::DISPOSITION_ATTACHMENT, \Zend_Mime::ENCODING_BASE64, $fileName);
            }
        }
    }
}
